/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos;

import java.net.URI;
import java.net.URISyntaxException;

public class VOSURI {
    public static final String SCHEME = "vos";
    private URI vosURI;

    public VOSURI(URI uri) {
        String path = uri.getPath();
        if (path != null && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            this.vosURI = new URI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI malformed: " + uri.toString());
        }
        if (this.vosURI.getScheme() == null || !this.vosURI.getScheme().equalsIgnoreCase(SCHEME)) {
            throw new IllegalArgumentException("URI scheme must be vos: " + uri.toString());
        }
    }

    public VOSURI(String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof VOSURI) {
            String a2;
            VOSURI vu = (VOSURI)rhs;
            String a1 = this.getAuthority();
            if (a1.equals(a2 = vu.getAuthority())) {
                return this.vosURI.equals(vu.vosURI);
            }
            if ((a1 = a1.replace('~', '!')).equals(a2 = a2.replace('~', '!'))) {
                int n = a1.length() + 6;
                String s1 = this.vosURI.toString().substring(n);
                String s2 = vu.toString().substring(n);
                return s1.equals(s2);
            }
        }
        return false;
    }

    public URI getURI() {
        return this.vosURI;
    }

    public String getAuthority() {
        return this.vosURI.getAuthority();
    }

    public String getFragment() {
        return this.vosURI.getFragment();
    }

    public String getPath() {
        return this.vosURI.getPath();
    }

    public String getPrefix() {
        return this.vosURI.getScheme() + "://" + this.vosURI.getAuthority();
    }

    public String getQuery() {
        return this.vosURI.getQuery();
    }

    public String getScheme() {
        return this.vosURI.getScheme();
    }

    public String getParent() {
        if (this.isRoot()) {
            return null;
        }
        String path = this.vosURI.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(0, index);
    }

    public VOSURI getParentURI() {
        if (this.isRoot()) {
            return null;
        }
        try {
            String path = this.getParent();
            URI uri = new URI(SCHEME, this.getAuthority(), path, null, null);
            return new VOSURI(uri);
        }
        catch (URISyntaxException bug) {
            throw new RuntimeException("BUG: failed to get parent uri from " + this.vosURI.toASCIIString(), bug);
        }
    }

    public String toString() {
        return this.vosURI.toString();
    }

    public String getName() {
        if (this.isRoot()) {
            return "";
        }
        String path = this.vosURI.getPath();
        String[] comps = this.vosURI.getPath().split("/");
        return comps[comps.length - 1];
    }

    public boolean isRoot() {
        String path = this.vosURI.getPath();
        return path == null || path.length() == 0 || path.equals("/");
    }

    public URI getServiceURI() {
        String authority = this.getAuthority();
        authority = authority.replace('!', '/');
        authority = authority.replace('~', '/');
        String str = "ivo://" + authority;
        try {
            return new URI(str);
        }
        catch (URISyntaxException bug) {
            throw new RuntimeException("BUG: failed to create service URI from VOSURI: " + this.vosURI);
        }
    }
}

