/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.client;

import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.HttpPost;
import ca.nrc.cadc.net.HttpRequestProperty;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobReader;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class ClientRecursiveSetNode
implements Runnable {
    private static Logger log = Logger.getLogger(ClientRecursiveSetNode.class);
    private static final long POLL_INTERVAL = 100L;
    private SSLSocketFactory sslSocketFactory;
    private URL jobURL;
    private Node node;
    private boolean monitorAsync;
    private boolean schemaValidation;
    private List<HttpRequestProperty> httpRequestProperties;
    private Throwable throwable;
    private ExecutionPhase phase;
    private ErrorSummary error;

    private ClientRecursiveSetNode() {
    }

    ClientRecursiveSetNode(URL jobURL, Node node, boolean schemaValidation) {
        this.httpRequestProperties = new ArrayList<HttpRequestProperty>();
        this.jobURL = jobURL;
        this.node = node;
        this.monitorAsync = false;
        this.schemaValidation = schemaValidation;
    }

    public URL getJobURL() {
        return this.jobURL;
    }

    public Node getNode() {
        return this.node;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public ExecutionPhase getPhase() throws IOException {
        if (this.phase != null) {
            return this.phase;
        }
        Job job = this.getJob();
        log.debug("Job: " + job);
        ExecutionPhase ep = job.getExecutionPhase();
        if (ExecutionPhase.ABORTED.equals((Object)ep) || ExecutionPhase.COMPLETED.equals((Object)ep) || ExecutionPhase.ERROR.equals((Object)ep)) {
            this.phase = ep;
        }
        return ep;
    }

    public ErrorSummary getServerError() throws IOException {
        if (this.error != null) {
            return this.error;
        }
        Job job = this.getJob();
        this.error = job.getErrorSummary();
        return this.error;
    }

    private Job getJob() throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpDownload get = new HttpDownload(this.jobURL, out);
            this.runHttpTransfer(get);
            if (get.getThrowable() != null) {
                throw new RuntimeException("Unable to get job because " + get.getThrowable().getLocalizedMessage());
            }
            JobReader jobReader = null;
            if (this.schemaValidation) {
                HashMap<String, String> extraSchemas = new HashMap<String, String>();
                String xsdFile = XmlUtil.getResourceUrlString("VOSpace-2.0.xsd", ClientRecursiveSetNode.class);
                extraSchemas.put("http://www.ivoa.net/xml/VOSpace/v2.0", xsdFile);
                xsdFile = XmlUtil.getResourceUrlString("VOSpace-2.1.xsd", ClientRecursiveSetNode.class);
                extraSchemas.put("http://www.ivoa.net/xml/VOSpace/v2.1", xsdFile);
                jobReader = new JobReader(extraSchemas);
            } else {
                jobReader = new JobReader(false);
            }
            return jobReader.read(new StringReader(new String(out.toByteArray(), "UTF-8")));
        }
        catch (ParseException ex) {
            throw new RuntimeException("failed to parse job from " + this.jobURL, ex);
        }
        catch (JDOMException ex) {
            throw new RuntimeException("failed to parse job from " + this.jobURL, ex);
        }
        catch (MalformedURLException bug) {
            throw new RuntimeException("BUG: failed to create error url", bug);
        }
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setRequestProperty(String header, String value) {
        this.httpRequestProperties.add(new HttpRequestProperty(header, value));
    }

    public void setMonitor(boolean enabled) {
        this.monitorAsync = enabled;
    }

    public void run() {
        log.debug("start: " + this.node);
        try {
            this.runRecursiveSetNode();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        log.debug("done: " + this.node);
    }

    private void runRecursiveSetNode() throws IOException, InterruptedException, RuntimeException {
        try {
            URL url = new URL(this.jobURL.toExternalForm() + "/phase");
            String content = "PHASE=RUN";
            String contentType = "application/x-www-form-urlencoded";
            boolean followRedirects = false;
            HttpPost post = new HttpPost(url, content, contentType, followRedirects);
            this.runHttpTransfer(post);
            if (post.getThrowable() != null) {
                throw new RuntimeException("Unable to run job because " + post.getThrowable().getLocalizedMessage());
            }
            if (this.monitorAsync) {
                while (this.phase == null) {
                    Thread.sleep(100L);
                    this.getPhase();
                }
            }
        }
        catch (MalformedURLException bug) {
            throw new RuntimeException("BUG: failed to create phase url", bug);
        }
    }

    private void runHttpTransfer(HttpTransfer transfer) {
        if (this.sslSocketFactory != null) {
            transfer.setSSLSocketFactory(this.sslSocketFactory);
        }
        transfer.run();
        if (transfer.getSSLSocketFactory() != null) {
            this.sslSocketFactory = transfer.getSSLSocketFactory();
        }
    }
}

