/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.client;

import ca.nrc.cadc.net.event.TransferEvent;
import ca.nrc.cadc.net.event.TransferListener;
import org.apache.log4j.Logger;

public class VOSpaceTransferListener
implements TransferListener {
    private static Logger log = Logger.getLogger(VOSpaceTransferListener.class);
    private boolean download;

    public VOSpaceTransferListener(boolean download) {
        this.download = download;
    }

    public String getEventHeader() {
        return null;
    }

    public void transferEvent(TransferEvent e) {
        switch (e.getState()) {
            case 1: 
            case 2: {
                log.info(e.getStateLabel() + ": " + e.getURL());
                break;
            }
            case 9: {
                log.info(e.getStateLabel() + ": " + e.getURL() + " -- retrying...");
                break;
            }
            case 7: {
                if (e.getFile() == null) {
                    log.info(e.getStateLabel() + ": " + e.getURL() + " -- " + e.getError().getMessage());
                    break;
                }
                if (this.download) {
                    log.info(e.getStateLabel() + ": " + e.getURL() + " -> " + e.getFile() + " -- " + e.getError().getMessage());
                    break;
                }
                log.info(e.getStateLabel() + ": " + e.getFile() + " -> " + e.getURL() + " -- " + e.getError().getMessage());
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                if (this.download) {
                    log.info(e.getStateLabel() + ": " + e.getURL() + " -> " + e.getFile());
                    break;
                }
                log.info(e.getStateLabel() + ": " + e.getFile() + " -> " + e.getURL());
                break;
            }
            default: {
                log.debug("transferEvent: " + e);
            }
        }
    }
}

