/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.LinkNode;
import ca.nrc.cadc.vos.LinkingException;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.NodePersistence;
import ca.nrc.cadc.vos.server.auth.VOSpaceAuthorizer;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PathResolver {
    protected static final Logger LOG = Logger.getLogger(PathResolver.class);
    private NodePersistence nodePersistence;
    private List<String> visitedPaths;
    private static final int VISIT_LIMIT_MAX = 40;
    private int visitLimit = 20;
    private int visitCount = 0;

    public PathResolver(NodePersistence nodePersistence) {
        if (nodePersistence == null) {
            throw new IllegalArgumentException("null node persistence.");
        }
        this.nodePersistence = nodePersistence;
    }

    public Node resolve(VOSURI uri) throws NodeNotFoundException, LinkingException, TransientException {
        return this.resolveWithReadPermissionCheck(uri, null, false);
    }

    public Node resolveWithReadPermissionCheck(VOSURI uri, VOSpaceAuthorizer readAuthorizer, boolean resolveLeafNodes) throws NodeNotFoundException, LinkingException, TransientException {
        this.visitCount = 0;
        this.visitedPaths = new ArrayList<String>();
        Node n = this.doResolve(uri, readAuthorizer);
        if (resolveLeafNodes) {
            return this.resolveLeafNodeWithReadPermissionCheck(uri, n, readAuthorizer);
        }
        return n;
    }

    public Node resolveLeafNodeWithReadPermissionCheck(VOSURI uri, Node node, VOSpaceAuthorizer readAuthorizer) throws NodeNotFoundException, LinkingException, TransientException {
        while (node instanceof LinkNode) {
            LinkNode linkNode = (LinkNode)node;
            PathResolver.validateTargetURI(linkNode);
            node = this.doResolve(new VOSURI(linkNode.getTarget()), readAuthorizer);
        }
        if (uri.getQuery() != null && node instanceof DataNode) {
            String fragment = null;
            if (uri.getFragment() != null) {
                fragment = uri.getFragment();
            }
            try {
                URI queryUri = new URI(node.getUri().getScheme(), node.getUri().getAuthority(), node.getUri().getPath(), uri.getQuery(), fragment);
                DataNode dataNode = new DataNode(new VOSURI(queryUri), node.getProperties());
                dataNode.setAccepts(node.accepts());
                dataNode.setProvides(node.provides());
                dataNode.setParent(node.getParent());
                dataNode.setName(node.getName());
                return dataNode;
            }
            catch (URISyntaxException e) {
                throw new LinkingException("Unable to append query part to " + node.getUri());
            }
        }
        return node;
    }

    private Node doResolve(VOSURI vosuri, VOSpaceAuthorizer readAuthorizer) throws NodeNotFoundException, LinkingException, TransientException {
        if (this.visitCount > this.visitLimit) {
            throw new LinkingException("Exceeded link limit.");
        }
        ++this.visitCount;
        LOG.debug("visit number " + this.visitCount);
        Node node = null;
        if (readAuthorizer != null) {
            try {
                node = (Node)readAuthorizer.getReadPermission(vosuri.getURI());
            }
            catch (FileNotFoundException ex) {
                throw new NodeNotFoundException("not found: " + vosuri);
            }
        } else {
            node = this.nodePersistence.get(vosuri, true);
        }
        LOG.debug("found node: " + node.getUri().toString());
        String requestedPath = vosuri.getPath();
        String nodePath = node.getUri().getPath();
        LOG.debug("[requested][resulting] path: [" + requestedPath + "][" + nodePath + "]");
        if (this.visitedPaths.contains(nodePath)) {
            LOG.debug("Found circular link: " + nodePath);
            throw new LinkingException("Circular link reference: " + nodePath);
        }
        this.visitedPaths.add(nodePath);
        LOG.debug("Added " + nodePath + " to visited list.");
        if (!requestedPath.equals(nodePath)) {
            if (!(node instanceof LinkNode)) {
                throw new NodeNotFoundException(vosuri.toString());
            }
            LinkNode linkNode = (LinkNode)node;
            String remainingPath = requestedPath.substring(nodePath.length());
            LOG.debug("remainingPath: " + remainingPath);
            VOSURI linkURI = PathResolver.validateTargetURI(linkNode);
            LOG.debug("linkURI: " + linkURI.toString());
            try {
                VOSURI resolvedURI = new VOSURI(linkURI.toString() + remainingPath);
                LOG.debug("resolvedURI: " + resolvedURI.toString());
                return this.doResolve(resolvedURI, readAuthorizer);
            }
            catch (URISyntaxException e) {
                throw new LinkingException("Invalid link URI");
            }
        }
        LOG.debug("returning node: " + node.getUri().toString());
        return node;
    }

    public static VOSURI validateTargetURI(LinkNode linkNode) throws LinkingException {
        VOSURI nodeURI = linkNode.getUri();
        URI targetURI = linkNode.getTarget();
        if (nodeURI.getScheme() == null || targetURI.getScheme() == null || !nodeURI.getScheme().equals(targetURI.getScheme())) {
            throw new LinkingException("Unsupported link target: " + targetURI);
        }
        try {
            VOSURI returnURI = new VOSURI(targetURI);
            String nodeAuth = nodeURI.getAuthority();
            String targetAuth = returnURI.getAuthority();
            if (nodeAuth == null || targetAuth == null) {
                throw new LinkingException("Non-local VOSpace target: " + targetURI);
            }
            if (!(nodeAuth = nodeAuth.replace('~', '!')).equals(targetAuth = targetAuth.replace('~', '!'))) {
                throw new LinkingException("Non-local VOSpace target: " + targetURI);
            }
            return returnURI;
        }
        catch (Exception e) {
            throw new LinkingException("Invalid target URI: " + targetURI, e);
        }
    }

    public void setVisitLimit(int visitLimit) {
        if (visitLimit > 40) {
            throw new IllegalArgumentException("Too high a visit limit.  Must be below 40");
        }
        this.visitLimit = visitLimit;
    }

    private void copy(Node src, Node dest) {
        src.setAccepts(dest.accepts());
        src.getProperties().addAll(dest.getProperties());
        src.setProvides(dest.provides());
    }
}

