/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.server.RssFeedItem;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jdom2.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssFeed {
    private static Logger log = Logger.getLogger(RssFeed.class);

    public static Element createFeed(Node parent, Collection<RssFeedItem> nodes, String baseURL) {
        String parentTitle = null;
        String parentDescription = null;
        for (NodeProperty nodeProperty : parent.getProperties()) {
            if (nodeProperty.getPropertyURI().equals("ivo://ivoa.net/vospace/core#title")) {
                parentTitle = nodeProperty.getPropertyValue();
            }
            if (!nodeProperty.getPropertyURI().equals("ivo://ivoa.net/vospace/core#description")) continue;
            parentDescription = nodeProperty.getPropertyValue();
        }
        Element rss = new Element("rss");
        rss.setAttribute("version", "2.0");
        Element channel = new Element("channel");
        rss.addContent(channel);
        if (parentTitle == null) {
            parentTitle = "Last modified nodes for " + parent.getName();
        }
        Element channelTitle = new Element("title");
        channelTitle.setText(parentTitle);
        channel.addContent(channelTitle);
        if (parentDescription == null) {
            parentDescription = nodes.size() + " last modified nodes";
        }
        Element channelDescription = new Element("description");
        channelDescription.setText(parentDescription);
        channel.addContent(channelDescription);
        Element link = new Element("link");
        link.setText(baseURL + parent.getUri().getPath() + "?view=rss");
        channel.addContent(link);
        NodeProperty creator = parent.findProperty("ivo://ivoa.net/vospace/core#creator");
        if (creator != null && StringUtil.hasText(creator.getPropertyValue())) {
            Element author = new Element("author");
            author.setText(creator.getPropertyValue());
            channel.addContent(author);
        }
        log.debug("num nodes: " + nodes.size());
        for (RssFeedItem rssFeedItem : nodes) {
            String nodeTitle = null;
            String nodeDescription = null;
            String nodeDate = null;
            for (NodeProperty nodeProperty : rssFeedItem.node.getProperties()) {
                if (nodeProperty.getPropertyURI().equals("ivo://ivoa.net/vospace/core#title")) {
                    nodeTitle = nodeProperty.getPropertyValue();
                }
                if (nodeProperty.getPropertyURI().equals("ivo://ivoa.net/vospace/core#description")) {
                    nodeDescription = nodeProperty.getPropertyValue();
                }
                if (!nodeProperty.getPropertyURI().equals("ivo://ivoa.net/vospace/core#date")) continue;
                nodeDate = nodeProperty.getPropertyValue();
            }
            Element item = new Element("item");
            if (nodeTitle == null) {
                nodeTitle = rssFeedItem.node.getName();
            }
            Element itemTitle = new Element("title");
            itemTitle.setText(nodeTitle);
            item.addContent(itemTitle);
            if (nodeDescription == null) {
                nodeDescription = rssFeedItem.node instanceof DataNode ? "File" : "Directory";
            }
            Element itemDescription = new Element("description");
            itemDescription.setText(nodeDescription);
            item.addContent(itemDescription);
            if (nodeDate != null) {
                Element itemPubDate = new Element("pubDate");
                itemPubDate.setText(nodeDate);
                item.addContent(itemPubDate);
            }
            Element itemLink = new Element("link");
            Element comments = new Element("comments");
            String linkText = baseURL + rssFeedItem.node.getUri().getPath();
            if (rssFeedItem.node instanceof DataNode) {
                linkText = linkText + "?view=data";
                comments.setText("Click to download this file.");
            } else {
                linkText = linkText + "?view=rss";
                comments.setText("Click to see the last modified nodes within this directory.");
            }
            itemLink.setText(linkText);
            item.addContent(itemLink);
            item.addContent(comments);
            creator = rssFeedItem.node.findProperty("ivo://ivoa.net/vospace/core#creator");
            if (creator != null && StringUtil.hasText(creator.getPropertyValue())) {
                Element author = new Element("author");
                author.setText(creator.getPropertyValue());
                item.addContent(author);
            }
            channel.addContent(item);
        }
        return rss;
    }

    public static Element createErrorFeed(Node node, Throwable throwable, String baseURL) {
        return RssFeed.createErrorFeed(node, throwable.getMessage(), baseURL);
    }

    public static Element createErrorFeed(Node node, String message, String baseURL) {
        Element rss = new Element("rss");
        rss.setAttribute("version", "2.0");
        Element channel = new Element("channel");
        rss.addContent(channel);
        Element title = new Element("title");
        String nodeName = node.getName();
        if (nodeName == null) {
            nodeName = "unknown node";
        }
        title.setText("Error processing Node " + nodeName);
        channel.addContent(title);
        Element link = new Element("link");
        String nodePath = node.getUri().getPath();
        if (nodePath == null) {
            link.setText("unknown link");
        } else {
            link.setText(baseURL + nodePath + "?view=rss");
        }
        channel.addContent(link);
        Element description = new Element("description");
        description.setText(message);
        channel.addContent(description);
        return rss;
    }
}

