/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.FileMetadata;
import ca.nrc.cadc.util.FileMetadataSource;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.NodePersistence;
import java.io.FileNotFoundException;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class VOSpaceFileMetadataSource
implements FileMetadataSource {
    protected static Logger log = Logger.getLogger(VOSpaceFileMetadataSource.class);
    private NodePersistence nodePersistence;

    public FileMetadata get(URI resource) throws FileNotFoundException, IllegalArgumentException, TransientException {
        VOSURI vos = new VOSURI(resource);
        Node persistentNode = this.getPersistentNode(vos);
        return this.get(persistentNode);
    }

    public FileMetadata get(Node persistentNode) throws FileNotFoundException, IllegalArgumentException {
        String lastModified;
        String md5Sum;
        String contentType;
        String contentLength;
        FileMetadata fileMetadata = new FileMetadata();
        fileMetadata.setFileName(persistentNode.getName());
        String contentEncoding = persistentNode.getPropertyValue("ivo://ivoa.net/vospace/core#encoding");
        if (contentEncoding != null) {
            fileMetadata.setContentEncoding(contentEncoding);
        }
        if ((contentLength = persistentNode.getPropertyValue("ivo://ivoa.net/vospace/core#length")) != null) {
            try {
                fileMetadata.setContentLength(new Long(contentLength));
            }
            catch (NumberFormatException e) {
                log.warn("Content Length is not a number for resource: " + persistentNode.getUri());
            }
        }
        if ((contentType = persistentNode.getPropertyValue("ivo://ivoa.net/vospace/core#type")) != null) {
            fileMetadata.setContentType(contentType);
        }
        if ((md5Sum = persistentNode.getPropertyValue("ivo://ivoa.net/vospace/core#MD5")) != null) {
            fileMetadata.setMd5Sum(md5Sum);
        }
        if ((lastModified = persistentNode.getPropertyValue("ivo://ivoa.net/vospace/core#date")) != null) {
            try {
                DateFormat df = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
                fileMetadata.setLastModified(df.parse(lastModified));
            }
            catch (ParseException e) {
                log.warn("Couldn't convert date string " + lastModified + " to Date object.", e);
            }
        }
        return fileMetadata;
    }

    public void set(URI resource, FileMetadata meta) throws FileNotFoundException, IllegalArgumentException, TransientException {
        VOSURI vos = new VOSURI(resource);
        Node persistentNode = this.getPersistentNode(vos);
        this.set(persistentNode, meta);
    }

    public void set(Node persistentNode, FileMetadata meta) throws FileNotFoundException, IllegalArgumentException, TransientException {
        if (meta == null) {
            throw new IllegalArgumentException("FileMetadata is null.");
        }
        if (persistentNode instanceof DataNode) {
            DataNode dn = (DataNode)persistentNode;
            this.nodePersistence.setFileMetadata(dn, meta, false);
        }
    }

    protected Node getPersistentNode(VOSURI resource) throws FileNotFoundException, TransientException {
        if (this.nodePersistence == null) {
            throw new IllegalStateException("NodePersistence not set.");
        }
        try {
            Node persistentNode = this.nodePersistence.get(resource);
            if (!(persistentNode instanceof DataNode)) {
                throw new IllegalArgumentException("not a data node: " + resource.getURI().toASCIIString());
            }
            return persistentNode;
        }
        catch (NodeNotFoundException ex) {
            throw new FileNotFoundException(resource.getURI().toASCIIString());
        }
    }

    public void setNodePersistence(NodePersistence nodePersistence) {
        this.nodePersistence = nodePersistence;
    }

    public NodePersistence getNodePersistence() {
        return this.nodePersistence;
    }
}

