/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.util;

import ca.nrc.cadc.vos.InvalidServiceException;
import org.apache.log4j.Logger;

public class BeanUtil {
    private static final Logger log = Logger.getLogger(BeanUtil.class);
    public static final String IVOA_VOS_URI = "ivoa.vos.uri";
    public static final String VOS_NODE_PERSISTENCE = "ca.nrc.cadc.vos.NodePersistence";
    public static final String VOS_STYLESHEET_REFERENCE = "VOSpaceStylesheetReference";
    private String className;

    public BeanUtil(String className) {
        this.className = className;
    }

    public Object createBean() throws InvalidServiceException {
        try {
            return Class.forName(this.getClassName()).newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error("No such bean >> " + this.getClassName(), e);
            throw new InvalidServiceException("No such bean >> " + this.getClassName(), e);
        }
        catch (IllegalAccessException e) {
            log.error("Class or Constructor is inaccessible for bean  >> " + this.getClassName(), e);
            throw new InvalidServiceException("Class or Constructor is inaccessible for bean >> " + this.getClassName(), e);
        }
        catch (InstantiationException e) {
            log.error("Cannot create bean instance >> " + this.getClassName(), e);
            throw new InvalidServiceException("Cannot create bean instance >> " + this.getClassName(), e);
        }
    }

    public String getClassName() {
        return this.className;
    }
}

