/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.restlet;

import ca.nrc.cadc.vos.InvalidServiceException;
import ca.nrc.cadc.vos.server.NodePersistence;
import ca.nrc.cadc.vos.server.util.BeanUtil;
import ca.nrc.cadc.vos.server.web.restlet.resource.NodeResource;
import java.util.Map;
import org.apache.log4j.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodesApplication
extends Application {
    private static final Logger log = Logger.getLogger(NodesApplication.class);

    public NodesApplication() {
    }

    public NodesApplication(Context context) {
        super(context);
    }

    public Restlet createInboundRoot() {
        Context context = this.getContext();
        String vosURI = context.getParameters().getFirstValue("ivoa.vos.uri");
        if (vosURI == null || vosURI.trim().length() == 0) {
            String message = "Context parameter not set: ivoa.vos.uri";
            log.error("Context parameter not set: ivoa.vos.uri");
            throw new RuntimeException("Context parameter not set: ivoa.vos.uri");
        }
        context.getAttributes().put("ivoa.vos.uri", vosURI);
        String stylesheetReference = context.getParameters().getFirstValue("VOSpaceStylesheetReference");
        context.getAttributes().put("VOSpaceStylesheetReference", stylesheetReference);
        this.createContextBean(context, NodePersistence.class, "ca.nrc.cadc.vos.NodePersistence");
        return new NodesRouter(context);
    }

    private void createContextBean(Context context, Class<?> beanInterface, String contextParam) {
        try {
            String className = context.getParameters().getFirstValue(contextParam);
            BeanUtil beanUtil = new BeanUtil(className);
            Object bean = beanUtil.createBean();
            if (beanInterface != null && !beanInterface.isInstance(bean)) {
                throw new InvalidServiceException("Bean does not implement interface: " + beanInterface.getName());
            }
            context.getAttributes().put(contextParam, bean);
            log.debug("Added " + contextParam + " bean to application context: " + className);
        }
        catch (InvalidServiceException e) {
            String message = "Could not create bean: " + contextParam + ": " + e.getMessage();
            log.error(message, e);
            throw new RuntimeException(message, e);
        }
    }

    private class NodesRouter
    extends Router {
        public NodesRouter(Context context) {
            super(context);
            this.attach("", NodeResource.class);
            this.attach("/", NodeResource.class);
            log.debug("attaching /{nodePath} -> NodeResource");
            Route nodeRoute = this.attach("/{nodePath}", NodeResource.class);
            Map nodeRouteVariables = nodeRoute.getTemplate().getVariables();
            nodeRouteVariables.put("nodePath", new Variable(1));
            log.debug("attaching /{nodePath} -> NodeResource - DONE");
        }
    }
}

