/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.restlet.action;

import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.vos.JsonNodeWriter;
import ca.nrc.cadc.vos.LinkingException;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeFault;
import ca.nrc.cadc.vos.NodeLockedException;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.NodeWriter;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.AbstractView;
import ca.nrc.cadc.vos.server.NodePersistence;
import ca.nrc.cadc.vos.server.Views;
import ca.nrc.cadc.vos.server.auth.VOSpaceAuthorizer;
import ca.nrc.cadc.vos.server.web.restlet.action.CreateNodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeActionResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.List;
import org.apache.log4j.Logger;
import org.restlet.Request;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.representation.Representation;

public abstract class NodeAction {
    protected static Logger log = Logger.getLogger(NodeAction.class);
    protected static final String QUERY_PARAM_VIEW = "view";
    protected static final String QUERY_PARAM_DETAIL = "detail";
    protected static final String QUERY_PARAM_URI = "uri";
    protected static final String QUERY_PARAM_LIMIT = "limit";
    protected Request request;
    protected Form queryForm;
    protected VOSpaceAuthorizer voSpaceAuthorizer;
    protected VOSpaceAuthorizer partialPathVOSpaceAuthorizer;
    protected NodePersistence nodePersistence;
    protected VOSURI vosURI;
    protected Representation nodeXML;
    protected String stylesheetReference;

    public void setVosURI(VOSURI vosURI) {
        this.vosURI = vosURI;
    }

    public void setNodeXML(Representation nodeXML) {
        this.nodeXML = nodeXML;
    }

    public void setVOSpaceAuthorizer(VOSpaceAuthorizer voSpaceAuthorizer) {
        this.voSpaceAuthorizer = voSpaceAuthorizer;
    }

    public void setPartialPathVOSpaceAuthorizer(VOSpaceAuthorizer partialPathVOSpaceAuthorizer) {
        this.partialPathVOSpaceAuthorizer = partialPathVOSpaceAuthorizer;
    }

    public void setNodePersistence(NodePersistence nodePersistence) {
        this.nodePersistence = nodePersistence;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setQueryForm(Form form) {
        this.queryForm = form;
    }

    public void setStylesheetReference(String stylesheetReference) {
        this.stylesheetReference = stylesheetReference;
    }

    protected MediaType getMediaType() {
        NodeAction nodeAction = this;
        List accepts = nodeAction.request.getCurrent().getClientInfo().getAcceptedMediaTypes();
        MediaType med = MediaType.TEXT_XML;
        for (Preference pmt : accepts) {
            if (!MediaType.TEXT_XML.equals((Object)pmt.getMetadata()) && !MediaType.APPLICATION_JSON.equals((Object)pmt.getMetadata())) continue;
            med = (MediaType)pmt.getMetadata();
            break;
        }
        return med;
    }

    protected NodeWriter getNodeWriter() {
        MediaType mt = this.getMediaType();
        if (MediaType.APPLICATION_JSON.equals((Object)mt)) {
            return new JsonNodeWriter();
        }
        return new NodeWriter();
    }

    protected AbstractView getView() throws Exception {
        String viewReference = this.queryForm.getFirstValue(QUERY_PARAM_VIEW);
        if (!StringUtil.hasText(viewReference)) {
            return null;
        }
        if (viewReference.equalsIgnoreCase("ivo://ivoa.net/vospace/core#defaultview")) {
            return null;
        }
        Views views = new Views();
        AbstractView view = views.getView(viewReference);
        if (view == null) {
            throw new UnsupportedOperationException("No view configured matching reference: " + viewReference);
        }
        view.setNodePersistence(this.nodePersistence);
        view.setVOSpaceAuthorizer(this.voSpaceAuthorizer);
        return view;
    }

    protected abstract NodeActionResult performNodeAction(Node var1, Node var2) throws URISyntaxException, NodeParsingException, FileNotFoundException, TransientException;

    protected abstract Node getClientNode() throws URISyntaxException, NodeParsingException, IOException;

    protected abstract Node doAuthorizationCheck() throws AccessControlException, FileNotFoundException, LinkingException, TransientException;

    public NodeActionResult run() throws TransientException {
        try {
            Node clientNode = this.getClientNode();
            if (clientNode != null) {
                log.debug("client node: " + clientNode.getUri());
            } else {
                log.debug("no client node");
            }
            long start = System.currentTimeMillis();
            Node serverNode = this.doAuthorizationCheck();
            long end = System.currentTimeMillis();
            log.debug("doAuthorizationCheck() elapsed time: " + (end - start) + "ms");
            log.debug("doAuthorizationCheck() returned server node: " + serverNode.getUri());
            start = System.currentTimeMillis();
            NodeActionResult result = this.performNodeAction(clientNode, serverNode);
            end = System.currentTimeMillis();
            log.debug("performNodeAction() elapsed time: " + (end - start) + "ms");
            return result;
        }
        catch (ByteLimitExceededException e) {
            String faultMessage = "XML document exceeds " + e.getLimit() + " bytes";
            log.debug(faultMessage);
            return this.handleException(NodeFault.RequestEntityTooLarge, faultMessage, false);
        }
        catch (FileNotFoundException e) {
            log.debug("Could not find node with path: " + this.vosURI.getPath());
            NodeFault nodeFault = this.handleException(e);
            String faultMessage = this.vosURI.toString();
            return this.handleException(nodeFault, faultMessage, false);
        }
        catch (URISyntaxException e) {
            String faultMessage = "URI not well formed: " + this.vosURI;
            log.debug(faultMessage);
            return this.handleException(NodeFault.InvalidURI, faultMessage, false);
        }
        catch (NodeLockedException e) {
            String faultMessage = "Node Locked: " + e.getMessage();
            log.debug(faultMessage);
            return this.handleException(NodeFault.NodeLocked, faultMessage, false);
        }
        catch (AccessControlException e) {
            String faultMessage = e.getMessage();
            if (!StringUtil.hasText(e.getMessage())) {
                faultMessage = "Access Denied";
            }
            log.debug(faultMessage);
            return this.handleException(NodeFault.PermissionDenied, faultMessage, false);
        }
        catch (NodeParsingException e) {
            String faultMessage = "Node XML not well formed: " + e.getMessage();
            log.debug(faultMessage);
            return this.handleException(NodeFault.TypeNotSupported, faultMessage, false);
        }
        catch (UnsupportedOperationException e) {
            String faultMessage = "Not supported: " + e.getMessage();
            log.debug(faultMessage);
            return this.handleException(NodeFault.InvalidArgument, faultMessage, false);
        }
        catch (IllegalArgumentException e) {
            String faultMessage = "Bad input: " + e.getMessage();
            log.debug(faultMessage);
            return this.handleException(NodeFault.InvalidArgument, faultMessage, false);
        }
        catch (LinkingException e) {
            String faultMessage = "Linking exception: " + e.getMessage();
            log.debug(faultMessage);
            return this.handleException(NodeFault.UnreadableLinkTarget, faultMessage, false);
        }
        catch (IllegalStateException e) {
            String faultMessage = e.getMessage();
            log.debug(faultMessage);
            return this.handleException(NodeFault.InternalFault, faultMessage, true);
        }
        catch (TransientException e) {
            throw e;
        }
        catch (Throwable t) {
            String faultMessage = "Internal Error:" + t.getMessage();
            log.debug("BUG: " + faultMessage, t);
            return this.handleException(NodeFault.InternalFault, faultMessage, true);
        }
    }

    protected NodeFault handleException(FileNotFoundException ex) throws TransientException {
        if (this instanceof CreateNodeAction) {
            return NodeFault.ContainerNotFound;
        }
        return NodeFault.NodeNotFound;
    }

    private NodeActionResult handleException(NodeFault nodeFault, String message, boolean serviceFailure) {
        nodeFault.setMessage(message);
        nodeFault.setServiceFailure(serviceFailure);
        return new NodeActionResult(nodeFault);
    }
}

