# Configuration file for the Sphinx documentation builder.

# -- Project information

project = 'ASPIS'
copyright = '2022, The Caesar/ASPIS team'
author = 'CAESAR Node 2000'

release = ''
version = '0.1.0'

# -- General configuration

extensions = [
    'sphinx.ext.duration',
    'sphinx.ext.doctest',
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.intersphinx',
    'sphinx.ext.autosectionlabel'
]

intersphinx_mapping = {
    'python': ('https://docs.python.org/3/', None),
    'sphinx': ('https://www.sphinx-doc.org/en/master/', None),
}
intersphinx_disabled_domains = ['std']

templates_path = ['_templates']

# -- Options for HTML output

# html_theme = 'sphinx_book_theme'
html_theme = 'classic'

# -- Options for EPUB output
epub_show_urls = 'footnote'

# -- Adding special navigation
html_theme_options = {
  "external_links": [
      {"name": "link-one-name", "url": "https://<link-one>"},
      {"name": "link-two-name", "url": "https://<link-two>"}
  ]
}
