% +++++++++++++++++++++++++++++++++++++++
%
% MATLAB webMust library for rest-API usage
% 
% test file 
% for any information regarding the API https://bepicolombo.esac.esa.int/webclient-must/mustlink/api-docs/index.html#/Projects/getProjects
%
% +++++++++++++++++++++++++++++++++++
% Creator: Carmelo Magnafico IAPS/INAF
% date: 10/07/2019
%
% ++++++++++++++++++

clear all
close all
addpath('./classes/');
M = MatMust;

credentials = jsondecode(fileread('credentials.json'));


% for info type help "MatMust_login"
opts = struct("username", credentials.username, "password",  credentials.password ,"maxDuration", false);
MatMust_login(M, opts);


% Ask for the Projects available to the user
proj_list = M.MatMust_getUserLinkedProjects('dump');
%%%
% with output:
% +++++++++++++ PROJECTS LIST +++++++++++++
% name: BEPITEST
% 	description: Test Database for Instruments  Team
% 	id: 8
% +++++++++++++++++	
% [...]
% +++++++++++++++++
% 	name: BEPICRUISE
% 	description: BepiColombo Cruise Phase
% 	id: 9
% +++++++++++++++++

act_proj = 'BEPICRUISE';
dataStart = '2018-11-26 13:00:00';
dataStop = '2018-11-26 13:40:00';



% for info type "help MatMust_getDataFromName"
% MatMust_getDataFromName(obj, ds, parname, dateStart, dateStop, options  )
data = M.MatMust_getDataFromName('BEPICRUISE', 'NSA03016', dataStart, dataStop);

% or if you want to plot 
data = M.MatMust_getDataFromName('BEPICRUISE', 'NSA03016', dataStart, dataStop, 'plot');

%search a mnemonic in 
data = M.MatMust_searchTMparFromName('Est sc ang rate', act_proj,'dump','Description');

%you can get more than a variable a time
data = M.MatMust_getDataFromName('BEPICRUISE', {'NCAD09A1','NCAD09A2','NCAD09A3'}, dataStart , dataStop, 'plot');



