#include<stdio.h>
#include "numa_vars.h"
#include "proto.h"


// Main Code
int main(int argc, char * argv[])
{


  if(argc > 1)
    {
      strcpy(in.paramfile,argv[1]);
    }
  else
    {
      fprintf(stderr, "Parameter file is not given\n");
      exit(1);
    }
 
  /* Initializing MPI Environment */

 #ifdef USE_MPI
 #ifdef _OPENMP
  int thread_level;
  MPI_Init_thread( &argc, &argv, MPI_THREAD_FUNNELED, &thread_level );
 #else
  MPI_Init(&argc,&argv);
 #endif
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  if(rank == 0)printf("Running with %d MPI tasks\n",size);
 #ifdef USE_FFTW
 #ifndef CUFFTMP
 #ifdef _OPENMP
 #ifdef HYBRID_FFTW
  threads_ok = thread_level >= MPI_THREAD_FUNNELED;
  if (threads_ok) threads_ok = fftw_init_threads();
 #endif
 #endif
  fftw_mpi_init();
 #endif
 #endif
 #ifdef RING
  MPI_Comm_dup(MPI_COMM_WORLD, &MYMPI_COMM_WORLD);
 #endif
 #else
  rank = 0;
  size = 1;
 #endif
 #ifdef ACCOMP
  if(rank == 0){
    if (0 == omp_get_num_devices()) {
      printf("No accelerator found ... exit\n");
      exit(255);
    }
    printf("Number of available GPUs %d\n", omp_get_num_devices());
   #ifdef NVIDIA
    prtAccelInfo();
   #endif
  }  
 #endif

  /* Reading Parameter file */

  read_parameter_file(in.paramfile);

  if ( param.num_threads == 0 )
    {
      fprintf(stderr, "Usage: %s number_of_OMP_Threads \n", param.num_threads);
      exit(1);
    }

      
  for(int ifiles=0; ifiles<param.ndatasets; ifiles++)
    {
      if(rank == 0)
	printf( "\nDataset %d\n", ifiles);

      /*INIT function */
      init(ifiles);

      /* GRIDDING function */
      gridding();

      /* WRITE_GRIDED_DATA function */
      write_grided_data();

      /* FFTW_DATA function */
      fftw_data();

      /* WRITE_FFTW_DATA function */
      write_fftw_data();
           

      /* WRITE_RESULT function */
      write_result();

     #ifdef RING //End of the NUMA machinery [GL]
      numa_shutdown(rank, 0, &MYMPI_COMM_WORLD, &Me);
     #endif
      
      if(rank == 0)
	printf("*************************************************************\n"); 

    }
       
  //Close MPI Environment
       
 #ifdef USE_MPI
  MPI_Finalize();
 #endif

}
