/* file to store global variables*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef USE_MPI
#include <mpi.h>
#ifdef USE_FFTW
#include <fftw3-mpi.h>
#endif
#endif
#ifdef ACCOMP
#include "w-stacking_omp.h"
#else
#include "w-stacking.h"
#endif
#ifdef NVIDIA
#include <cuda_runtime.h>
#endif
#define PI 3.14159265359
#define NUM_OF_SECTORS -1
#define MIN(X, Y) (((X) < (Y)) ? (X) : (Y))
#define MAX(X, Y) (((X) > (Y)) ? (X) : (Y))
#define NOVERBOSE
#define NFILES 100
#include <omp.h>
#include <math.h>
#include <time.h>
#include <unistd.h>

extern struct io
{
	FILE * pFile;
        FILE * pFile1;
        FILE * pFilereal;
        FILE * pFileimg;
} file;

extern struct ip
{
	char ufile[30];
  	char vfile[30];
  	char wfile[30];
  	char weightsfile[30];
  	char visrealfile[30];
  	char visimgfile[30];
  	char metafile[30];
        char paramfile[30];
} in;

extern struct op
{
	char outfile[30];
        char outfile1[30];
        char outfile2[30];
        char outfile3[30];
        char fftfile[30];
        char fftfile2[30];
        char fftfile3[30];
        char logfile[30];
        char extension[30];
        char timingfile[30];

} out, outparam;

extern struct meta
{

	long Nmeasures,Nmeasures0;
        long Nvis,Nvis0;
        long Nweights,Nweights0;
        long freq_per_chan,freq_per_chan0;
        long polarisations,polarisations0;
        long Ntimes,Ntimes0;
        double dt,dt0;
        double thours,thours0;
        long baselines,baselines0;
        double uvmin,uvmin0;
        double uvmax,uvmax0;
        double wmin,wmin0;
        double wmax,wmax0;

} metaData;


extern struct time
{
   	double setup_time, process_time, mpi_time, fftw_time, tot_time, kernel_time, reduce_time, compose_time, phase_time;
	double setup_time1, process_time1, mpi_time1, fftw_time1, tot_time1, kernel_time1, reduce_time1, compose_time1, phase_time1;
	double writetime, writetime1;

} timing;

extern struct parameter
{
        int num_threads;
        int ndatasets;
        char datapath_multi[NFILES][900];
} param;

extern struct fileData
{
        double * uu;
        double * vv;
        double * ww;
        float * weights;
        float * visreal;
        float * visimg;
}data;

extern struct sectorlist {
     long index;
     struct sectorlist * next;
}** sectorhead;


extern char filename[1000], buf[30], num_buf[30];
extern char datapath[900];
extern int xaxis, yaxis;
extern int grid_size_x;
extern int grid_size_y;
extern int num_w_planes, w_support;
extern int rank;
extern int size;
extern long nsectors;
extern long startrow;
extern double resolution, dx, dw, w_supporth;

extern clock_t start, end, start0, startk, endk;
extern struct timespec begin, finish, begin0, begink, finishk;
extern long * histo_send, size_of_grid;
extern double * grid, *gridss, *gridss_real, *gridss_img, *gridss_w;
extern fftw_complex *fftwgrid;

#ifdef USE_MPI
    extern  MPI_Win slabwin;
#endif
