# HPC_Imaging

To compile the code, feel free to activate and deactivate options in the Makefile.
You will find the code options before and then the acceleration options.

You can simply run the code with the command:

############################################

make w-stacking

############################################

It will redirect you to the file Build/Makefile.local, which is complete enough
apart from different library paths, feel free to use it or to change SYSTYPE.
My aim was to make compilation as simple as possible.

When you use GPU offloading with OpenMP, please do not compile the CPU part with NVC.
This can be easily fixed by setting the environment variable:

############################################

export OMPI_CC = gcc

###########################################

In the case in which the default compiler is NVC. The Makefile is suited to understand
which are the parts to be compiled with NVC for the OpenMP offloading.
The final linker in this case will be however the NVC/NVC++.

The problem does not raise on AMD platforms, because you use clang/clang++ for both CPUs
and GPUs

The extensions of the executable will be changed depending on the different acceleration
options.

To run the code, the data/paramfile.txt is available. Feel free to change the paramers,
i.e. the path of visibilities, which reduce implementation to use, the number of pixels,
the number of OpenMP threads and so on.

Once you have compiled the code, run it simply with the command:

###########################################

mpirun -np [n] [executable] data/paramfile.txt

###########################################

In the case in which the code has been compiled without either -fopenmp or -D_OPENMP options,
the code is forced to use the standard MPI_Reduce implementation, since our reduce works
only with OpenMP.

To use the cufftMp with nvhpc 23.5 you have to add the following paths to the environmental variable ´LD_LIBRARY_PATH´:

###########################################

export LD_LIBRARY_PATH="/leonardo/prod/spack/03/install/0.19/linux-rhel8-icelake/gcc-11.3.0/nvhpc-23.5-pdmwq3k5perrhdqyrv2hspv4poqrb2dr/Linux_x86_64/23.5/comm_libs/11.8/nvshmem_cufftmp_compat/lib/:$LD_LIBRARY_PATH"

export LD_LIBRARY_PATH="/leonardo/prod/spack/03/install/0.19/linux-rhel8-icelake/gcc-11.3.0/nvhpc-23.5-pdmwq3k5perrhdqyrv2hspv4poqrb2dr/Linux_x86_64/23.5/math_libs/11.8/lib64/:$LD_LIBRARY_PATH"

###########################################