#include<stdio.h>
#include "allvars.h"
#include "proto.h"

void write_result() {
       
       end = clock();
       clock_gettime(CLOCK_MONOTONIC, &finish);
       timing.tot_time = ((double) (end - start0)) / CLOCKS_PER_SEC;
       timing.tot_time1 = (finish.tv_sec - begin0.tv_sec);
       timing.tot_time1 += (finish.tv_nsec - begin0.tv_nsec) / 1000000000.0;
       
       if (rank == 0)
        {
          printf("Setup time:    %f sec\n",timing.setup_time);
          printf("Process time:  %f sec\n",timing.process_time);
          printf("Kernel time = %f, Array Composition time %f, Reduce time: %f sec\n",timing.kernel_time,timing.compose_time,timing.reduce_time);
          #ifdef USE_FFTW
              printf("FFTW time:     %f sec\n",timing.fftw_time);
              printf("Phase time:    %f sec\n",timing.phase_time);
          #endif
          printf("TOT time:      %f sec\n",timing.tot_time);
          if(param.num_threads > 1)
          {
            printf("PSetup time:   %f sec\n",timing.setup_time1);
            printf("PProcess time: %f sec\n",timing.process_time1);
            printf("PKernel time = %f, PArray Composition time %f, PReduce time: %f sec\n",timing.kernel_time1,timing.compose_time1,timing.reduce_time1);
            #ifdef USE_FFTW
               printf("PFFTW time:    %f sec\n",timing.fftw_time1);
               printf("PPhase time:   %f sec\n",timing.phase_time1);
            #endif
            printf("PTOT time:     %f sec\n",timing.tot_time1);
          }
        }

        if (rank == 0)
        {
         file.pFile = fopen (out.timingfile,"w");
         if (param.num_threads == 1)
         {
           fprintf(file.pFile, "%f %f %f %f %f %f %f\n",timing.setup_time,timing.kernel_time,timing.compose_time,timing.reduce_time,timing.fftw_time,timing.phase_time,timing.tot_time);
         } else {
           fprintf(file.pFile, "%f %f %f %f %f %f %f\n",timing.setup_time1,timing.kernel_time1,timing.compose_time1,timing.reduce_time1,timing.fftw_time1,timing.phase_time1,timing.tot_time1);
         }
         fclose(file.pFile);
        }
        
        #ifdef USE_MPI
           MPI_Win_fence(0,slabwin);
           MPI_Win_free(&slabwin);
        #endif
}
