#!/usr/bin/env python

'''
PySQM configuration File.
____________________________

Copyright (c) Mireia Nievas <mnievas[at]ucm[dot]es>

This file is part of PySQM.

PySQM is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

PySQM is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with PySQM.  If not, see <http://www.gnu.org/licenses/>.

____________________________
Notes:

You may need to change the following variables to match your
observatory coordinates, instrumental properties, etc.

Python syntax is mandatory.
____________________________
'''

'''
-------------
SITE location
-------------
'''
_observatory_name = 'INAF_OATo' # Name of the observatory
_observatory_latitude = 45.039868 # Latitude N of the observatory [deg]
_observatory_longitude = 7.762582 # Longitude E of the observatory [deg]
_observatory_altitude = 600 # Altitude from sea level of the observatory [m]
_observatory_horizon = 90 #  Altitude of the Sun below which the program will take data [deg]

'''
------------
DEVICE specs
------------
'''
_device_shorttype = 'SQM' # Device STR in the file
_device_type = 'SQM_LE' # Device type in the Header
_device_id = _device_type + '-' + _observatory_name # Long Device lame
_device_locationname = 'Pino Torinese/Italy - Astrophysical Observatory of Torino' # Device location in the world
_data_supplier = 'Dario Barghini / INAF - OATo' # Data supplier (contact)
_device_addr = '169.254.156.64' # Default IP address of the ethernet device (if not automatically found)

'''
----------------
MEASURE settings
----------------
'''
_local_timezone = +1 # UTC+1
_computer_timezone  = +0 # UTC
_offset_calibration = -0.11 # Calibration offset (e.g. due to the SQM housing window)
_measures_to_promediate = 1  # Take the mean of N measures
_delay_between_measures = 300  # Delay between two measures [sec]
_cache_measures = 1 # Get X measures before writing on screen/file
_plot_each = 1 # Call the plot function each X measures
_reboot_on_connlost = False # Reboot if we loose connection

'''
----------
mySQL info
----------
'''
_use_mysql = False # Set to True if you want to store data on a MySQL db
_mysql_host = None # Host (ip:port / localhost) of the MySQL engine
_mysql_user = None # User with write permission on the db
_mysql_pass = None # Password for that user
_mysql_database = None # Name of the database
_mysql_dbtable = None # Name of the table
_mysql_port = None # Port of the MySQL server

'''
------------------
DIRECTORY settings
------------------
'''
main_directory = "C:\\sqm\\pysqm_data" # Main directory
monthly_data_directory = main_directory + "\\monthly\\" # Monthly (permanent) data
daily_data_directory = main_directory + "\\daily\\" # Daily (permanent) data
daily_graph_directory = main_directory + "\\daily\\" # Daily (permanent) graph
current_data_directory = main_directory + "\\current\\" # Current data, deleted each day
current_graph_directory = main_directory + "\\current\\"  # Current graph, deleted each day
summary_data_directory = main_directory + "\\current\\"  # Summary with statistics for the night

'''
------------
PLOT options
------------
'''
full_plot = True
limits_nsb = [20.0, 0.] # Limits in y-axis (MPSAS)
limits_time = [12, 12] # Hours
limits_sunalt = [-80, 5] # Degrees

'''
----------------------------
PySQM data center (OPTIONAL)
----------------------------
'''
_send_to_datacenter = False # Send the data to the data center

'''
-------------
EMAIL options
-------------
'''
_send_data_by_email = False