#!/usr/bin/env python

from distutils.core import setup

setup(name='pysqm',
      version='4',
      maintainer='Dario Barghini',
      maintainer_email='dario.barghini@inaf.it',
      url='https://www.ict.inaf.it/gitlab/dario.barghini/pysqm_darkersky4ce.git',
      license='GPLv3',
      description='SQM reading and plotting software',
      packages=['pysqm'],
      install_requires=['pyephem','numpy','matplotlib'],
      classifiers=[
                   "Programming Language :: C",
                   "Programming Language :: Cython",
                   "Programming Language :: Python :: 3",
                   "Programming Language :: Python :: Implementation :: CPython",
                   'Development Status :: 3 - Alpha',
                   "Environment :: Other Environment",
                   "Intended Audience :: Science/Research",
                   "License :: OSI Approved :: GNU General Public License (GPL)",
                   "Operating System :: OS Independent",
                   "Topic :: Scientific/Engineering :: Astronomy",
                   ],
      long_description=open('README.md', encoding="utf-8").read(),
      entry_points={"console_scripts": ["pysqm=pysqm.__main__:main"]}
      )
