#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
Utilities related to URLs
'''


def build_url(itn):
    """
    Build an URL from info of a .ini file
    """

    user = itn.get("user") or ""
    pwd = ":" + itn["password"] + "@" if itn.get("password") else ""
    if itn.get("protocol"):
        if itn["protocol"] == "tcp":
            prot = itn["protocol"] + ":"
        else:
            prot = itn["protocol"] + "://"
    else:
        prot = ""
    ip = itn["ip"]
    endp = itn.get("endpoint") or ""
    port = ":" + itn["port"] if itn.get("port") else ""

    url = prot + user + pwd + ip + port + endp

    return url
