# software-di-controllo

Instrument Control Software for small class observatory.
Currently in use at OARPAF

## Python dependencies:

```
# For the core routines:
pip3 install requests loguru astropy
pip3 install gnuplotlib pyvantagepro # maybe I'll drop these.

# For the API:
pip3 install flask flask-restx werkzeug
# Tested with flask==3.0.2 werkzeug-3.0.1 flask-restx==1.3.0 

# For the web interface:
pip3 install flask flask-socketio flask-httpauth
# Tested with flask==3.0.2 werkzeug-3.0.1 flask-socketio==5.3.6 flask-httpauth==4.8.0

```

## Add the nodes of your observatory:

For example, in `config/nodes.ini`:

```
[MY_ASCOM_REMOTE_SERVER]
protocol = http
ip = 192.168.1.111
hostname = ascom.myobservatory.net
port = 533
endpoint = /api/v1

[MY_SONOFF_ADDRESS]
protocol = https
user = admin
password = admin
ip = 192.168.1.222
hostname = sonoff.myobservatory.net
port = 1234

```

## Connect the devices in your observatory to the nodes:

For example, in `config/devices.ini`:

```
[my_tel]            
module = alpaca 
class = Telescope
node = MY_ASCOM_REMOTE_SERVER   

[my_dome]            
module = alpaca  
class = Dome    
node = MY_ASCOM_REMOTE_SERVER

[my_light]
module = domotics
class = Switch
node = MY_SONOFF_ADDRESS
outlet = 3

[my_dome_temperature]
module = domotics
class = Sensor
node = MY_SONOFF_ADDRESS
outlet1 = 1
outlet2 = 2

```

## Low-level control of your devices using ipython:

```

import devices
devices.my_dome.azimuth # 123
devices.my_dome.azimuth = 234

```

## Give to every device a REST API endpoint, or more

For example, in `config/api.ini`:

```
[/dome/position]
resource = Position
device = my_dome


[/dome/light]
resource = State
device = my_light

[/alias/to/light]
resource = State
device = my_light

[/dome/temperature]
resource = State
device = my_dome_temperature

[/telescope/coordinates]
resource = Coordinates
device = my_tel

```

## REST API-level control of your devices using curl:

First, start the API server with `./app.py 1111 localhost --noweb`

```
curl http://localhost:1111/api/dome/position

# {
#   "error" : [],
#   "raw" : true,
#   "response" : {
#      "azimuth" : 123.00,
#      "parked" : "Yes"
#   },
#   "timestamp" : "2024-03-26T16:48:13.766195"
# }

# other examples:

# Change azimuth
curl -X POST http://localhost:1111/api/dome/position -d '234' -H 'Content-Type:application/json'

# Retrieve all GET endpoints relative to the dome 
curl http://localhost:1111/all/dome

```

## Web-based control of your observatory:

Doc in progress



# Branches:

- main

[![pipeline status](https://www.ict.inaf.it/gitlab/davide.ricci/software-di-controllo/badges/main/pipeline.svg)](https://www.ict.inaf.it/gitlab/davide.ricci/software-di-controllo/commits/main)

[![Latest Release](https://www.ict.inaf.it/gitlab/davide.ricci/software-di-controllo/-/badges/release.svg)](https://www.ict.inaf.it/gitlab/davide.ricci/software-di-controllo/-/releases)


