#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
Constants used in the whole project
'''

# Telescope

lat = 44.5912  # [°] Latitude North from Greenwich.
lon = 9.2034  # [°] Longitude East from Greenwich.
alt = 1469  # [m] Altitude above sea level.

############
# Dome
############

dome_park_position = 57  # azimuth
# alt, az to point the screen with dome parked
telescope_flat_position = [24, 240]

open_state = {
    0: "Open",
    1: "Closed",
    2: "Opening",
    3: "Closing",
    4: "Error",
    None: "Off",
}

yes_no = {
    True: "Yes",
    False: "No",
    None: "N/A",
}

############
# Switches
############

on_off = {
    True: "On",
    False: "Off",
    None: "N/A",
}

############
# Camera
############

xmax = [0, 4145]  # max xrange in binning 1.
ymax = [0, 4126]  # max yrange in binning 1.

pixscale = 0.283  # arcsec/px in binning 1. From a resolved FITS
rotangle = -89.67  # -90 # typical rotation angle. From a resolved FITS

temp_fits = "temp.fits"
temp_fits0 = "temp0.fits"

filter_state = {
    0: "Idle",
    1: "Moving",
    2: "Error",
    None: "Off",
}

filter_name = {
    0: "Undef.",
    1: "U",
    2: "B",
    3: "V",
    4: "R",
    5: "I",
    6: "Halpha",
    7: "Free",
    15: "Filter_error",
    None: "Off",
}

# Reversing filter_name
filter_number = {v: k for k, v in filter_name.items()}

camera_state = {
    0: "Idle",
    2: "Exposing",
    3: "Readout",
    5: "Error",
    None: "Off",
}

# Reversing camera state
camera_number = {v: k for k, v in camera_state.items()}

frame_type = {
    0: "Dark",
    1: "Light",
    2: "Bias",
    3: "Flat",
}

# Reversing frame_type
frame_number = {v: k for k, v in frame_type.items()}

image_state = {
    0: "Not ready for download",
    1: "Ready for download",
}

# Reversing image_state
image_number = {v: k for k, v in image_state.items()}

############
# Directories
############

DATA_FOLDER_NAME = "data"
LOG_DIRECTORY_NAME = "log"
fits_folder = "fits"
focus_folder = "focus"

# data_folder = "data"
# log_folder = "log"

dir_type = {
    0: "dark",
    1: "object",
    2: "bias",
    3: "flat",
}

# Reversing dir_type
dir_number = {v: k for k, v in dir_type.items()}

############
# Logging
############

# Log file naming
LOG_FILE_EXTENSION = ".log"
LATEST_LOG_FILENAME = "latest"

# Rotation settings (used by logger.py)
LOG_ROTATION_TIME_H = 12 # Midday (hour in UTC)
LOG_ROTATION_TIME_M = 0  # Midday (minute in UTC)
LOG_ROTATION_TIME_S = 0  # Midday (second in UTC)
LOG_ROTATION_INTERVAL_DAYS = 1 # Rotate daily
LOG_BACKUP_COUNT = 0 # 0 means keep all backup files (infinite)

############
# FITS
############

# keywords
imagetyp = "IMAGETYP"  # 'Light'
dateobs = "DATE-OBS"  # '2021-12-18T05:09:56.163'

FILE_PREFIX = "OARPAF."
ext = ".fits" # File extension
focus_ext = ".foc"
