#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# System modules

# Other templates
from ..config.constants import on_off
from ..devices import lamp, light
from ..utils.logger import log
from .basetemplate import BaseTemplate


class Template(BaseTemplate):
    '''Switches off all the lamps.'''

    def __init__(self):
        '''Constructor.'''

        super().__init__()
        self.name = __name__
        self.description = "Switches off all the lamps"

    def content(self, params={}):

        for source in [lamp, light]:
            log.info(
                f"{source.description} found to be {on_off[source.state]}")

            while source.state:
                log.debug(f"{source.description} still {on_off[source.state]}")
                source.state = False

            log.info(f"{source.description} is now {on_off[source.state]}")
