#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# System modules
from time import sleep

# Third-party modules
from templates.basetemplate import BaseTemplate

# Other templates
from ..config.constants import on_off
from ..devices import light
from ..utils.logger import log


class Template(BaseTemplate):
    def __init__(self):
        super().__init__()
        self.name = "testlamp"
        self.description = "Test template"

    def content(self, params):

        light.state = True
        log.info(f"Switched {light.description} {on_off[light.state]}")

        sleep(3)

        # light.state = False
        # log.info(f"Switched {light.description} {on_off[light.state]}")

        return
