#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
Base device. Other devices inherit from this
"""

# System modules

# Other templates
from ..utils.logger import log


class BaseDevice:
    '''Base device class for our devices'''

    def __init__(self, url):
        '''Constructor.'''

        self.url = url
        self.error = []

    def get(self, message):
        '''Implement a getter method to obtain info from your device.'''
        try:
            self.error = []
            return message
        except Exception as e:
            log.error(e)
            self.error.append(e)
            return message

    def put(self, message):
        '''Implement a setter method to send info to your device.'''
        try:
            self.error = []
            return message
        except Exception as e:
            log.error(e)
            self.error.append(e)
            return message

    @property
    def test_attribute(self):
        '''res = self.get("")
           self._test_attribute = res
           return self._test_attribute
        '''
        try:
            return self._test_attribute
        except AttributeError as e:
            self._test_attribute = None
            log.warning("Still no test attribute. Set to None")
            return self._test_attribute

    @test_attribute.setter
    def test_attribute(self, value):
        '''res = self.put(value)
           self._test_attribute = self.test_attribute
        '''
        self._test_attribute = value
        # self._test_attribute = self.test_attribute

    def test_method(self):
        return "Method tested"
