#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# System modules

# Other templates
from ..devices import cam
from ..utils.logger import log
from .basetemplate import BaseTemplate
from .observation import Template as Observation


class Template(BaseTemplate):
    def __init__(self):
        super().__init__()
        self.name = "box"
        self.description = "Makes a boxed image around given coords"

    def content(self, params):

        ########################
        ##### Params check #####
        ########################

        try:
            objname = params.get("object") or "test"
            filt = params["filter"]
            binning = params["binning"]
            exptime = params["exptime"]
            center = params.get("center") or cam.center
            width = params.get("width") or 40 // binning  # px
            height = params.get("height") or 40 // binning  # ~12''

        except KeyError as e:
            log.error(f"Parameter {e} not found")
            return

        fixed = {"repeat": 1,
                 "frametype": "Light"
                 }

        params.update(fixed)

        ########################
        ##### Camera setup #####
        ########################

        centx, centy = center

        log.info(f"Windowing camera: center {center}, size {width}x{height}")
        cam.xrange = [centx - width // 2, centx + width // 2]
        cam.yrange = [centy - height // 2, centy + height // 2]
        log.info(
            f"Camera windows now: xrange {cam.xrange}, yrange {cam.yrange}")
        log.info(f"Which means start xy: {cam.xystart}, end xy: {cam.xyend}")

        ##################################
        ##### Calling Observation tpl ####
        ##################################

        # Adding Obs xy parameters,
        # otherwise it takes the full frame
        obs_params = {
            "xystart": cam.xystart,
            "xyend": cam.xyend
        }

        params.update(obs_params)

        obs = Observation()
        obs.run(params)

        return
