#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Third-party modules
import numpy as np
from astropy.time import Time

# Other templates
from ..config.constants import on_off
# from devices import lamp, light
from ..utils.logger import log
from ..utils.structure import foc_path
from .basetemplate import BaseTemplate


class Template(BaseTemplate):
    '''Writes a data file.'''

    def __init__(self):
        '''Constructor.'''

        super().__init__()
        self.name = __name__
        self.description = "Switches off all the lamps"

    def content(self, params={}):

        # Initial comment about variables a, b, c
        comment = "These are the variables a, b, c in the file."

        # Variables
        a = ["A", "B", "C"]
        b = [1, 2, 3]
        c = [0.1, 0.2, 0.3]

        # Writing to a space-separated text file (appending)
        file_path = foc_path(Time.now().isot)

        # Write the initial comment if the file doesn't exist
        with open(file_path, "a+") as file:
            file.seek(0)
            if not file.read(1):
                file.write(f"# {comment}\n")

        # Append lines in subsequent iterations
        for a_val, b_val, c_val in zip(a, b, c):

            # opening all the time and not at begginning just for safety
            with open(file_path, "a") as file:
                file.write(f"{a_val} {b_val} {c_val}\n")

        log.info(f"File '{file_path}' updated successfully.")
