#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# System modules


# Other templates
from ..utils.logger import log
from .basetemplate import BaseTemplate
from .observation import Template as Observation


class Template(BaseTemplate):
    def __init__(self):
        super().__init__()
        self.name = "bias"
        self.description = "Takes a set of bias calibrations"

    def content(self, params):

        ########################
        ##### Params check #####
        ########################

        try:
            binning = params["binning"]
            repeat = params.get("repeat") or 1
        except KeyError as e:
            log.error(f"Parameter {e} not found")

        fixed = {
            "objname": "Bias frame",
            "exptime": 0,
            "filter": "U",
            "frametype": "Bias"
        }

        params.update(fixed)

        ###################################
        ##### Calling Observation tpl #####
        ###################################

        obs = Observation()
        obs.run(params)

        return
