# SWIPE LabVIEW INSTALLATION GUIDE

HELLO!
Here is a quick guide to get SWIPE LabVIEW up and running on a new machine without getting crazy.

1. PREREQUISITES
   • Operating System: Windows 10 or newer (64-bit)  
   • LabVIEW: Version 2022 Q3 (64-bit) 
     – Download and install from NI  
     – Activate your LabVIEW license before proceeding

2. DEPENDENCIES
   a) VI Package Manager (VIPM)  
      – Install the Live HDF5 package (v1.2.2.5) via VIPM  
      – Package name: lvhdf5-1.2.2.5

   b) Visual Studio (for C++/CLI DLL)  
      – Install “Desktop development with C++” workload  
      – Tested on VS 2022 (any recent version should work)

   c) HDF5 File Visualizer  
      – Download and install from the HDF Group (you have to register to the site before being able to download):  
        https://www.hdfgroup.org/download-hdf5/
   d) HDF5 View 
	- Download and install from the HDF Group https://www.hdfgroup.org/download-hdfview/ (software that allows to visualize the File 	  HDF5)

3. INSTALLATION STEPS
   1. Clone or copy the project folder to your machine.  
   2. Open SWIPE LabView.lvproj in LabVIEW.  
   3. Select the VI "Fifo_ToBinaryFile3_07_2024_tests"
   4. LabVIEW will compile and search for all VIs and DLLs.  

      Expected DLLs (place in <project-root>\dlls or add that folder to your PATH, because LabView will start searching them in a default path, you have to select "Browse…" and search them inside the folder LABVIEW SWIPE 29_04_25):  
        • spcm_win64.dll  
        • spcm_datasort_win64.dll  
        • my_my_second_top_beautiful_DLL.dll  

      If you see missing-DLL errors for the custom DLL, ensure C++/CLI support is installed.

4. CONFIGURING THE WAV PLAYER
   • Default WAV: Barbiere_di_Siviglia.wav (in <project-root>\sounds)  (but if you have just downloaded it you need to reset it)
   • Before running the VI, set the “Base Path” (top-left of front panel) to your WAV file.  
   • If no valid WAV is selected, the acquisition will halt when it finishes.

5. RUNNING THE PROJECT
   1. Ensure all dependencies are installed and the project is open.  
   2. Click “Run” in LabVIEW.  
   3. Watch the “Errors” window for missing-VI or missing-DLL warnings.  
   4. If no broken arrow "Run" the program should work.
   5. After acquisition completes, the selected WAV file will play automatically.
   6. Enjoy the HDF5 file from the acquisition. 

6. TROUBLESHOOTING
   – Missing VI errors  
     • Verify Live HDF5 is installed in VIPM  
     • Check VI search paths include the HDF5 package folder

   – DLL load failures  
     • Confirm DLLs are in a folder on your Windows PATH 
     • Reinstall the Visual C++ Redistributable matching your VS version

   – WAV file not found  
     • Double-check the Base Path points to a valid .wav file  
     • Ensure file permissions allow LabVIEW to read it.
 
7. Problems?

For every problem contact: edoardo.borciani@inaf.it

