#ifndef MYLIBRARY_H
#define MYLIBRARY_H

#ifdef _WIN32
#ifdef EXPORTING_DLL
#define DLL_API __declspec(dllexport)
#else
#define DLL_API __declspec(dllimport)
#endif
#define STDCALL __stdcall
#else
#define DLL_API
#define STDCALL
#endif

#ifdef __cplusplus
extern "C" {
#endif

    DLL_API void STDCALL delay(double x[], double y[], int N, int M);
    DLL_API void STDCALL differentiator(double x[], double y[], int N, int M);
    DLL_API void STDCALL iir_1st(double x[], double y[], int N, double b0, double b1, double a1);
    DLL_API void STDCALL iir_2nd(double x[], double y[], int N, double b0, double b1, double b2, double a1, double a2);
    DLL_API void STDCALL trapz(double x[], double y[], int N, double beta, int R, int M);
    DLL_API void STDCALL timing_flt(double x[], double y[], int N, int C, int F);

#ifdef __cplusplus
}
#endif

#endif // MYLIBRARY_H
