# Generated by Django 2.2.1 on 2021-11-08 14:45

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core_app', '0010_profile_is_power_user'),
    ]

    operations = [
        migrations.CreateModel(
            name='Storage',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('type', models.CharField(max_length=255, verbose_name='Type')),
                ('access_mode', models.CharField(max_length=36, verbose_name='Access (control) mode')),
                ('auth_mode', models.CharField(max_length=36, verbose_name='Auth mode')),
                ('base_path', models.CharField(max_length=4096, verbose_name='Base path')),
                ('bind_path', models.CharField(max_length=4096, verbose_name='Bind path')),
                ('access_through_computing', models.BooleanField(default=False, verbose_name='Access through linked computing resource?')),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('computing', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='storages', to='core_app.Computing')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
    ]
