#/bin/bash

if [[ "x$@" == "x" ]] ; then

    # Set port (defaults to 8888)
    if [ "x$BASE_PORT" == "x" ]; then
        BASE_PORT=8888
        echo "[INFO] using default Notebook server port (8888)"
    else
        echo "[INFO] Setting Notebook server port to $BASE_PORT" 
    fi
    
    # Set password (defaults to none)
    if [ "x$AUTH_PASS" == "x" ]; then
        echo "[INFO] Not using anyNotebook server password" 
    else
        echo "[INFO] Setting Notebook server password to $AUTH_PASS" 
    fi
    
    # Set base dir (defaults to root).
    if [ "x$BASE_DIR" == "x" ]; then
        BASE_DIR='/'
    else
        BASE_DIR="'$BASE_DIR'"
    fi
    
    # Run the Jupyter Notebook server.  Use --allow-root if need to run as root. 
    exec jupyter notebook --ip=0.0.0.0 --port=$BASE_PORT --no-browser --NotebookApp.token=$AUTH_PASS --NotebookApp.notebook_dir=$BASE_DIR
    
else

    ENTRYPOINT_COMMAND=$@
    echo -n "Executing Docker entrypoint command: "
    echo $ENTRYPOINT_COMMAND
    exec /bin/bash -c "$ENTRYPOINT_COMMAND"
    
fi