# Containers

Various Docker and Singularity containers.

### Hierarchy

- Base
  - X11Web
     - MinimalDesktop
       - BasicDesktop
         - ViaLacteaVisualAnalytics
  - JupyterNotebook
  - SSH
    - XCalc

### Interfaces

The container starts by automatically exposing their interfaces:


 - The containers based on the X11Web container (as the desktops) expose a web-based VNC client (KasmVNC) on port 8590

- The JupyterNotebook container expose the Notebook server on port 8888

- The SSH container expose the OpenSSH server on port 22

All the containers support changing the default port using the `BASE_PORT` environment variable.


### Usage

You can eithe directly run the containers, e.g.:

    docker run -p8590:8590 registry.ict.inaf.it/exact/swc/basicdesktop:v0.3.0
 
 or use tham as base containers for your own ones:
 
    FROM registry.ict.inaf.it/exact/swc/basicdesktop:v0.3.0
 
 
### Supported engines
 
 These containers are built to be supported by nearly any container engine. These include:
 
  - Docker
  - Podman (rootful and rootless)
  - Singularity
 
 However, beware some permission errors which may arise after extending them and installing extra software, in particular with Singularity. You can add a line like this at the end of your Dockerfile to be sure the home folder is always set as writable by anyone (required for these containers to work with Singularity):
 
    # Fix home permissions
    RUN chmod 777 /home
