# Singularity support for the NP-TMcode project

## Using the pre-built image
The current version of NP-TMcode (M10a) has been bundled in a pre-built `singularity` image, available from the sylabs cloud repository of singularity images at `https://cloud.sylabs.io/library/gmulas/np-tmcode-run/np-tmcode-run.sif`. To use this image, pull it with the command:

   > singularity pull np-tmcode-run.sif library://gmulas/np-tmcode-run/np-tmcode-run.sif:m10a.00

then place the `np-tmcode-run.sif` file in the `containers/singularity` folder of the NP-TMcode project.

## Building a local image
A local image containing the necessary code requirements and binary files can be built through the image definition file provided along with the code. This `np-tmcode-run.def` file allows to create a `np-tmcode-run` image, that contains only the pre-built executables, python test scripts, compiled documentation, and the minimal runtime to run them.

In order for the singularity build to create the image, singularity build must be invoked from this directory as:

   > singularity build \<image name\> np-tmcode-run.def

where `<image name>` is the name one wants to give to the image, e.g. `np-tmcode-run.sif`. Depending on the singularity installation, the additional `--fakeroot` option may be needed (see singularity documentation).

The image thus built can be run either as

   > singularity run \<image name\> \<np-tmcode command\>

or directly as

   > \<full path to image name\> \<np-tmcode command\>

where `<full path to image name>` is the name of the sif image, including full or relative path to it, and `<np-tmcode command>` is one of the executables built in np-tmcode project, or one of the accessory python scripts distributed with the code. These executables, as well as the minimum runtime for them to execute correctly, are embedded in the image, and "see" the current directory the image is run in (which technically is automatically bind-mounted by singularity in the running image instance). To further ease their use, one can also use the provided wrapper shell script, by setting the `SIFFILE` environment variable to the full path to the singularity image and then running the links with their respective names to `singwrapper` in the `scripts` directory.


# License

   Copyright (C) 2025   INAF - Osservatorio Astronomico di Cagliari

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   A copy of the GNU General Public License is distributed along with
   this program in the COPYING file. If not, see: <https://www.gnu.org/licenses/>.
