/*! \file np_sphere.cpp
 */

#include <cstdio>
#include <complex>
#include <string>

#ifndef INCLUDE_CONFIGURATION_H_
#include "../include/Configuration.h"
#endif

using namespace std;

extern void cluster(string config_file, string data_file, string output_path);

/*! \brief Main program entry point.
 *
 * This is the starting point of the execution flow. Here we may choose
 * how to configure the code, e.g. by loading a legacy configuration file
 * or some otherwise formatted configuration data set. The code can be
 * linked to a luncher script or to a GUI oriented application that performs
 * the configuration and runs the main program.
 */
int main(int argc, char **argv) {
  	string config_file = "../../test_data/cluster/DEDFB";
	string data_file = "../../test_data/cluster/DCLU";
	string output_path = ".";
	if (argc == 4) {
		config_file = string(argv[1]);
		data_file = string(argv[2]);
		output_path = string(argv[3]);
	}
	cluster(config_file, data_file, output_path);
	return 0;
}
