/*! \file Parsers.cpp
 */

#include <fstream>
#include <string>
#include "../include/List.h"
#include "../include/Parsers.h"

std::string *load_file(std::string file_name, int *count = 0) {
  std::fstream input_file(file_name.c_str(), std::ios::in);
  List<std::string> file_lines = List<std::string>();
  std::string line;
  if (input_file.is_open()) {
    getline(input_file, line);
    file_lines.set(0, line);
    while (getline(input_file, line)) {
      file_lines.append(line);
    }
    input_file.close();
  } else {
	  throw FILE_NOT_FOUND_ERROR;
  }
  std::string *array_lines = file_lines.to_array();
  if (count != 0) *count = file_lines.length();
  return array_lines;
}
