/* Copyright 2024 INAF - Osservatorio Astronomico di Cagliari

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

/*! \file types.h
 *
 * \brief Definition of fundamental types in use.
 */

#ifndef INCLUDE_TYPES_H_
#define INCLUDE_TYPES_H_

#include <complex.h>

typedef __complex__ double dcomplex;

#ifdef USE_MKL
#ifdef USE_ILP64
#ifndef MKL_INT 
#define MKL_INT int64_t
#endif // MKL_INT
#else
#ifndef MKL_INT 
#define MKL_INT int32_t
#endif // MKL_INT
#endif // USE_ILP64
#endif // USE_MKL

#ifdef USE_LAPACK
#ifdef USE_MKL
#include <mkl_lapacke.h>
#else
#include <lapacke.h>
#endif // USE_MKL
#endif // USE_LAPACK

#ifdef USE_MAGMA
#include <magma_v2.h>
#endif

#ifndef np_int
#ifdef lapack_int
#define np_int lapack_int
#else
#ifdef USE_ILP64
#define np_int int64_t
#else
#define np_int int32_t
#endif // USE_ILP64
#endif // lapack_int
#endif // np_int

/*! \brief Get the real part of a complex number.
 *
 * \param z: `complex double` The argument of the function.
 * \return rz: `double` The real part of the argument.
 */
double real(dcomplex z);

/*! \brief Get the imaginary part of a complex number.
 *
 * \param z: `complex double` The argument of the function.
 * \return iz: `double` The imaginary part of the argument.
 */
double imag(dcomplex z);
#endif
