# Folder instructions

This directory collects the input files to test the code.

## Instructions

The execution of the original code can be controlled through a set of configuration files that define the characteristics of the problem and affect the type of output. The following sections describe the contents of the configuration files and, to some extent, those of the output ones, presenting one code in each section.

### cluster

`clu` is designed to calculate a complex geometry made up by many spheres. These can be either fully embedded in a larger sphere or separated within the external medium. Sphere compenetration is not accounted for.

*TODO:* add the description of the cluster configuration files

### sphere

`sph` is designed to perform the simplest case calculation, namely the scattering of incident radiation on a single sphere. To perform the calculation, the two following formatted files need to be provided:

- DEDFB
```
   SPHERE_NUMBER   EXTERNAL_SPHERE_FLAG
   EXT_DIEL_CONST   PEAK_WAVE   PEAK_SCALE   DIEL_TYPE   SCALE_NUMBER   SCALE_STEP_FLAG   CONTROL_VARIABLE
   SCALE_VECTOR   [SCALE_VECTOR_STEP]
        |
	v
   SPHERE_ID_VECTOR ->
   LAYER_NUMBER_VECTOR   SPHERE_RADII_VECTOR
            |                     |
	    v                     v
   FRACTIONAL_BREAK_RADII ->
             |
	     v
   DIEL_CONST_VECTOR ->
          |
	  v
   EOF_CODE
```
were the different lines have the following roles:
1. declare the number of spheres and whether to add an external layer
2. define the external dielectric constant and the scaling configuration
3. define the vector of scales (either explicitly, with one element per row, or in steps, with only first element and step declared)
4. create a vector of IDs to attach to the spheres
5. define the vectors spcifying the number of layers and the radii of the spheres (one sphere per line)
6. define the fractional break radii (one line per sphere, one column per layer)
7. define the vector of dielectric constants or starting functions (one line per sphere, one column per layer)
8. an end-of-file code (generally 0)

- DSPH
```
  SPHERE_NUMBER  MAXIMUM_L_ORDER  POLARIZATION_STATUS  TRANSITION_SHARPNESS_1  TRANSITION_SHARPNESS_2  GEOMETRY
  STARTING_INC_THETA  INC_THETA_STEP  FINAL_INC_THETA  STARTING_SCA_THETA  SCA_THETA_STEP  FINAL_SCA_THETA
  STARTING_INC_PHI  INC_PHI_STEP  FINAL_INC_PHI  STARTING_SCA_PHI  SCA_PHI_STEP  FINAL_SCA_PHI
  WRITE_INTERMEDIATE_FILE
EOF_CODE
```
were the different lines have the following roles:
1. general configuration of the scattering problem, with some specification of the transition between materials
2. definition of the elevation angle arrays for the incident and scattered radiation fields
3. definition of the azimuth angle arrays for the incident and scattered radiation fields
4. a flag to set whether the intermediate data should be written to output files
5. an end-of-file code (generally 0)

# License

# License

   Copyright (C) 2024   INAF - Osservatorio Astronomico di Cagliari

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   A copy of the GNU General Public License is distributed along with
   this program in the COPYING file. If not, see: <https://www.gnu.org/licenses/>.
