# Folder instructions

This directory collects all the output of make builds.

## Instructions

The original code produces output in the current working directory (the path where the code is executed from). The build directory is intended to collect local builds and test run output in a safe place, without cluttering the code development folders, thus helping `git` to filter out unnecessary logs through `.gitignore`.

## Code work-flow

This section describes the use of the pre-existing programs, once the binaries have been properly built by a succesful run of `make` in the `src` folder.

### cluster

1. cd to the `build/cluster` folder.
2. Run `edfb_clu`:
   
   > ./edfb_clu
   
3. Run `clu`:
   
   > ./clu
   
*NOTE:* both `edfb_clu` and `clu` expect an input which is assumed to be in a folder named `../../test_data/cluster/` (i.e. two levels above the current execution path)

4. Run `np_cluster`:

   > ./np_cluster

*NOTE:* The *C++* version does not need to run a configuration program because all configuration operations are handled by the code at run-time.

5. Check the consistency between the output files (the default output file for the *FORTRAN* code is named `OCLU`, while the corresponding *C++* output has the default name of `c_OCLU`).

The default behaviour of `np_cluster` is to take the same input files as `edfb_clu` and `clu` and to write the output in the current folder. If needed, different input and output paths can be given as command-line arguments:

   > ./np_cluster PATH_TO_DEDFB PATH_TO_DCLU OUTPUT_PATH

### sphere

1. cd to the `build/sphere` folder.
2. Run `edfb_sph`:

   > ./edfb_sph
   
3. Run `sph`:

   > ./sph
   
*NOTE:* both `edfb_sph` and `sph` expect an input which is assumed to be in a folder named `../../test_data/sphere/` (i.e. two levels above the current execution path)

4. Run `np_sphere`:

   > ./np_sphere

*NOTE:* The *C++* version does not need to run a configuration program because all configuration operations are handled by the code at run-time.

5. Check the consistency between the output files (the default output file for the *FORTRAN* code is named `OSPH`, while the corresponding *C++* output has the default name of `c_OSPH`).

The default behaviour of `np_sphere` is to take the same input files as `edfb_sph` and `sph` and to write the output in the current folder. If needed, different input and output paths can be given as command-line arguments:

   > ./np_sphere PATH_TO_DEDFB PATH_TO_DSPH OUTPUT_PATH

### trapping

The execution of trapping programs requires at least one of the previous programs to have produced a complete output set. A light-weight trapping calculation has been configured with input and legacy output files stored in the `../../test_data/trapping/` folder. Since the FORTRAN code assumes the input and output to be defined within the program, it is not yet possible to run the *FORTRAN* version on this case, unless the source code is modified accordingly. Conversely, the *C++* version can be executed without the need to modify and re-compile the code. The work-flow to test trapping is described below.

1. cd to the `build/sphere` folder.
2. run `np_sphere` with arguments to take input from the trapping test and write output in the trapping build folder:

   > ./np_sphere ../../test_data/trapping/DEDFB ../../test_data/trapping/DSPH ../trapping

3. cd to the trapping folder.
4. run `np_trapping`

   > ./np_trapping ../../test_data/trapping/DFRFME ../../test_data/trapping/DLFFT .

5. Check the consistency between `np_trapping` output files (`c_out66.txt` and `c_out67.txt`) and the legacy *FORTRAN* output for this case (the files named, respectively, `fort.66` and `fort.67` in the `test_data/trapping/` folder). Consider that some of the output values will be affected by numeric noise and take substantially different values. However, this is expected for results whose order of magnitude is clearly below the precision level of the calculation, as they represent results appraching zero that were just approximated with different precision.
