# Singularity support for the NP-TMcode project

This `np-tmcode-run.def` file allows to create a np-tmcode-run image, that contains only the pre-built executables, python test scripts, compiled documentation, and the minimal runtime to run them

In order for the singularity build to create the image, singularity build must be invoked from this directory as:

   > singularity build \<image name\> np-tmcode-run.def

where `<image name>` is the name one wants to give to the image, e.g. `np-tmcode-run.sif`. Depending on the singularity installation, the additional `--fakeroot` option may be needed (see singularity documentation).

The image thus built can be run either as

   > singularity run \<image name\> \<np-tmcode command\>

or directly as

   > \<full path to image name\> \<np-tmcode command\>

where `<full path to image name>` is the name of the sif image, including full or relative path to it, and `<np-tmcode command>` is one of the executables built in np-tmcode project, or the `pycompare.py` script used to compare results between the Fortran and C++ versions of the code. These executables, as well as the minimum runtime for them to execute correctly, are embedded in the image, and "see" the current directory the image is run in (which technically is automatically bind-mounted by singularity in the running image instance).