import math
import random
import yaml

#import pdb

from pathlib import PurePath
from sys import argv

seed = int(argv[1])

random.seed(seed)

config = {}
with open('config_rand.yml', 'r') as stream:
    config = yaml.safe_load(stream)

nsph = int(config['particle_settings']['n_spheres'])

vec_thetas = [0.0 for i in range(nsph)]
vec_phis = [0.0 for i in range(nsph)]
vec_rads = [0.0 for i in range(nsph)]

n_types = config['particle_settings']['n_types']
if (len(config['particle_settings']['sph_types']) > 0):
    if (len(config['particle_settings']['sph_types']) != nsph):
        print("ERROR: declared number of types does not match the number of spheres!")
        exit(1)
else:
    # Random type generation
    for ti in range(nsph):
        itype = 1 + int(n_types * random.random())
        config['particle_settings']['sph_types'].append(itype)
sph_type_index = config['particle_settings']['sph_types'][0] - 1
vec_spheres = [{'itype': sph_type_index + 1, 'x': 0.0, 'y': 0.0, 'z': 0.0}]
vec_rads[0] = config['particle_settings']['radii'][sph_type_index]
max_rad = 20.0 * vec_rads[0]
placed_spheres = 1
attempts = 0
max_attempts = 100
for i in range(1, nsph):
    sph_type_index = config['particle_settings']['sph_types'][i] - 1
    vec_rads[i] = config['particle_settings']['radii'][sph_type_index]
    is_placed = False
    #breakpoint()
    while (not is_placed):
        if (attempts > max_attempts):
            print("WARNING: could not place sphere %d in allowed radius!"%i)
            break # while(not is_placed)
        vec_thetas[i] = math.pi * random.random()
        vec_phis[i] = 2.0 * math.pi * random.random()
        rho = vec_rads[0] + vec_rads[i]
        z = rho * math.cos(vec_thetas[i])
        y = rho * math.sin(vec_thetas[i]) * math.sin(vec_phis[i])
        x = rho * math.sin(vec_thetas[i]) * math.cos(vec_phis[i])
        j = 0
        while (j < i - 1):
            j += 1
            dx2 = (x - vec_spheres[j]['x']) * (x - vec_spheres[j]['x'])
            dy2 = (y - vec_spheres[j]['y']) * (y - vec_spheres[j]['y'])
            dz2 = (z - vec_spheres[j]['z']) * (z - vec_spheres[j]['z'])
            dist2 = dx2 + dy2 + dz2
            rr2 = (vec_rads[i] + vec_rads[j]) * (vec_rads[i] + vec_rads[j])
            if (dist2 < rr2):
                # Spheres i and j are compenetrating.
                # Sphere i is moved out radially until it becomes externally
                # tangent to sphere j. Then the check is repeated, to verify
                # that no other sphere was penetrated. The process is iterated
                # until sphere i is placed or the maximum allowed radius is
                # reached.
                sinthi = math.sin(vec_thetas[i])
                sinthj = math.sin(vec_thetas[j])
                costhi = math.cos(vec_thetas[i])
                costhj = math.cos(vec_thetas[j])
                sinphi = math.sin(vec_phis[i])
                sinphj = math.sin(vec_phis[j])
                cosphi = math.cos(vec_phis[i])
                cosphj = math.cos(vec_phis[j])
                cosalpha = (
                    sinthi * cosphi * sinthj * cosphj
                    + sinthi * sinphi * sinthj * sinphj
                    + costhi * costhj
                )
                rho += 2.0 * vec_rads[j] * cosalpha
                z = rho * math.cos(vec_thetas[i])
                y = rho * math.sin(vec_thetas[i]) * math.sin(vec_phis[i])
                x = rho * math.sin(vec_thetas[i]) * math.cos(vec_phis[i])
                j = 0
                continue # while(j < i - 1)
        if (rho + vec_rads[i] > max_rad):
            # The current direction is filled. Try another one.
            attempts += 1
            continue # while(not is_placed)
        vec_spheres.append({
            'itype': sph_type_index + 1,
            'x': x,
            'y': y,
            'z': z
        })
        is_placed = True
        placed_spheres += 1
        attempts = 0

print(vec_spheres)
print(sorted(vec_spheres, key=lambda item: item['itype']))
