/* Copyright 2024 INAF - Osservatorio Astronomico di Cagliari

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

/*! \file lapack_calls.cpp
 *
 * \brief Implementation of the interface with LAPACK libraries.
 */
#ifndef INCLUDE_TYPES_H_
#include "../include/types.h"
#endif

/*
#ifdef USE_LAPACK
#ifdef USE_MKL
#include <mkl_lapacke.h>
#else
#include <lapacke.h>
#endif
*/

#ifdef USE_LAPACK
#ifndef INCLUDE_LAPACK_CALLS_H_
#include "../include/lapack_calls.h"
#endif

void zinvert(dcomplex **mat, np_int n, int &jer) {
  jer = 0;
  dcomplex *arr = &(mat[0][0]);
  const dcomplex uim = 0.0 + 1.0 * I;

#ifdef USE_MKL
  MKL_Complex16 *arr2 = (MKL_Complex16 *) arr;
#endif
  
  np_int* IPIV = new np_int[n]();
  
#ifdef USE_MKL
  LAPACKE_zgetrf(LAPACK_ROW_MAJOR, n, n, arr2, n, IPIV);
  LAPACKE_zgetri(LAPACK_ROW_MAJOR, n, arr2, n, IPIV);
#else
  LAPACKE_zgetrf(LAPACK_ROW_MAJOR, n, n, arr, n, IPIV);
  LAPACKE_zgetri(LAPACK_ROW_MAJOR, n, arr, n, IPIV);
#endif

  delete[] IPIV;
}
#endif
