/* Distributed under the terms of GPLv3 or later. See COPYING for details. */

/*! \file Commons.cpp
 *
 * DEVELOPMENT NOTE:
 * The construction of common blocks requires some information
 * that is stored in configuration objects and is needed to compute
 * the allocation size of vectors and matrices. Currently, this
 * information is passed as arguments to the constructors of the
 * common blocks. A simpler and more logical way to operate would
 * be to design the constructors to take as arguments only pointers
 * to the configuration objects. These, on their turn, need to
 * expose methods to access the relevant data in read-only mode.
 */
#ifndef INCLUDE_TYPES_H_
#include "../include/types.h"
#endif

#ifndef INCLUDE_COMMONS_H
#include "../include/Commons.h"
#endif

C1::C1(int ns, int l_max, int *_nshl, int *_iog) {
  nlmmt = 2 * (l_max * (l_max + 2));
  nsph = ns;
  lm = l_max;

  vec_rmi = new dcomplex[nsph * lm]();
  vec_rei = new dcomplex[nsph * lm]();
  rmi = new dcomplex*[lm];
  rei = new dcomplex*[lm];
  for (int ri = 0; ri < lm; ri++) {
    rmi[ri] = &(vec_rmi[nsph * ri]);
    rei[ri] = &(vec_rei[nsph * ri]);
  }
  vec_w = new dcomplex[4 * nlmmt]();
  w = new dcomplex*[nlmmt];
  for (int wi = 0; wi < nlmmt; wi++) w[wi] = &(vec_w[4 * wi]);
  int configurations = 0;
  for (int ci = 1; ci <= nsph; ci++) {
    if (_iog[ci - 1] >= ci) configurations++;
  }
  vint = new dcomplex[16]();
  vec_vints = new dcomplex[nsph * 16]();
  vints = new dcomplex*[nsph];
  rc = new double*[configurations];
  nshl = new int[configurations]();
  iog = new int[nsph]();
  int conf_index = 0;
  for (int vi = 0; vi < nsph; vi++) {
    vints[vi] = &(vec_vints[vi * 16]);
    iog[vi] = _iog[vi];
    if (iog[vi] >= vi + 1) {
      nshl[conf_index] = _nshl[conf_index];
      rc[conf_index] = new double[_nshl[conf_index]]();
      conf_index++;
    }
  }
  fsas = new dcomplex[nsph]();
  sscs = new double[nsph]();
  sexs = new double[nsph]();
  sabs = new double[nsph]();
  sqscs = new double[nsph]();
  sqexs = new double[nsph]();
  sqabs = new double[nsph]();
  gcsv = new double[nsph]();
  rxx = new double[nsph]();
  ryy = new double[nsph]();
  rzz = new double[nsph]();
  ros = new double[nsph]();

  sas = new dcomplex**[nsph];
  for (int si = 0; si < nsph; si++) {
    sas[si] = new dcomplex*[2];
    sas[si][0] = new dcomplex[2]();
    sas[si][1] = new dcomplex[2]();
  }
}

C1::~C1() {
  delete[] vec_rmi;
  delete[] vec_rei;
  delete[] rmi;
  delete[] rei;
  delete[] vec_w;
  delete[] w;
  int conf_index = 0;
  for (int ci = 1; ci <= nsph; ci++) {
    if (iog[ci] >= ci) {
      delete[] rc[conf_index];
      conf_index++;
    }
  }
  delete[] rc;
  delete[] vint;
  delete[] vec_vints;
  delete[] vints;
  for (int si = nsph - 1; si > -1; si--) {
    delete[] sas[si][1];
    delete[] sas[si][0];
    delete[] sas[si];
  }
  delete[] sas;
  delete[] fsas;
  delete[] sscs;
  delete[] sexs;
  delete[] sabs;
  delete[] sqscs;
  delete[] sqexs;
  delete[] sqabs;
  delete[] gcsv;
  delete[] rxx;
  delete[] ryy;
  delete[] rzz;
  delete[] ros;
  delete[] iog;
  delete[] nshl;
}

C1_AddOns::C1_AddOns(C4 *c4) {
  nsph = c4->nsph;
  lmpo = c4->lmpo;
  nlemt = 2 * c4->nlem;
  vh = new dcomplex[(nsph * nsph - 1) * c4->litpo]();
  vj0 = new dcomplex[nsph * c4->lmtpo]();
  vj = new dcomplex[1](); // QUESTION: is 1 really enough for a general case?
  vyhj = new dcomplex[(nsph * nsph - 1) * c4->litpos]();
  vyj0 = new dcomplex[nsph * c4->lmtpos]();
  am0m = new dcomplex*[nlemt];
  for (int ai = 0; ai < nlemt; ai++) {
    am0m[ai] = new dcomplex[nlemt]();
  }
  vintm = new dcomplex[16]();
  vintt = new dcomplex[16]();
  fsac = new dcomplex*[2];
  sac = new dcomplex*[2];
  fsacm = new dcomplex*[2];
  for (int fi = 0; fi < 2; fi++) {
    fsac[fi] = new dcomplex[2]();
    sac[fi] = new dcomplex[2]();
    fsacm[fi] = new dcomplex[2]();
  }
  scscp = new dcomplex[2]();
  ecscp = new dcomplex[2]();
  scscpm = new dcomplex[2]();
  ecscpm = new dcomplex[2]();
  allocate_vectors(c4);
  sscs = new double[nsph]();
  ecscm = new double[2]();
  scscm = new double[2]();
  scsc = new double[2]();
  ecsc = new double[2]();
}

C1_AddOns::~C1_AddOns() {
  delete[] sscs;
  delete[] vyj0;
  delete[] vyhj;
  for (int ii = lmpo - 1; ii > -1; ii--) delete[] ind3j[ii];
  delete[] ind3j;
  delete[] v3j0;
  delete[] vh;
  delete[] vj0;
  for (int ai = nlemt - 1; ai > -1; ai--) {
    delete[] am0m[ai];
  }
  delete am0m;
  delete[] vintm;
  delete[] vintt;
  for (int fi = 1; fi > -1; fi--) {
    delete[] fsac[fi];
    delete[] sac[fi];
    delete[] fsacm[fi];
  }
  delete[] fsac;
  delete[] sac;
  delete[] fsacm;
  delete[] scscp;
  delete[] ecscp;
  delete[] scscpm;
  delete[] ecscpm;
  delete[] ecscm;
  delete[] scscm;
  delete[] scsc;
  delete[] ecsc;
}

void C1_AddOns::allocate_vectors(C4 *c4) {
  // This calculates the size of v3j0
  int lm = (c4->li > c4->le) ? c4->li : c4->le;
  const int nv3j = c4->nv3j;
  v3j0 = new double[nv3j]();
  ind3j = new int*[lmpo];
  for (int ii = 0; ii < lmpo; ii++) ind3j[ii] = new int[c4->lm]();
  // This calculates the size of vyhj
  int ivy = (nsph * nsph - 1) * c4->litpos;
  vyhj = new dcomplex[ivy]();
  // This calculates the size of vyj0
  ivy = c4->lmtpos * c4->nsph;
  vyj0 = new dcomplex[ivy]();
}

C2::C2(int ns, int nl, int npnt, int npntts) {
  nsph = ns;
  int max_n = (npnt > npntts) ? npnt : npntts;
  nhspo = 2 * max_n - 1;
  ris = new dcomplex[nhspo]();
  dlri = new dcomplex[nhspo]();
  vkt = new dcomplex[nsph]();
  dc0 = new dcomplex[nl]();
  vsz = new double[nsph]();
}

C2::~C2() {
  delete[] ris;
  delete[] dlri;
  delete[] vkt;
  delete[] dc0;
  delete[] vsz;
}

C3::C3() {
  tsas = new dcomplex*[2];
  tsas[0] = new dcomplex[2];
  tsas[1] = new dcomplex[2];
  tfsas = 0.0 + 0.0 * I;
  gcs = 0.0;
  scs = 0.0;
  ecs = 0.0;
  acs = 0.0;
}

C3::~C3() {
  delete[] tsas[1];
  delete[] tsas[0];
  delete[] tsas;
}

C6::C6(int lmtpo) {
  rac3j = new double[lmtpo]();
}

C6::~C6() {
  delete[] rac3j;
}

C9::C9(int ndi, int nlem, int ndit, int nlemt) {
  gis = new dcomplex*[ndi];
  gls = new dcomplex*[ndi];
  for (int gi = 0; gi < ndi; gi++) {
    gis[gi] = new dcomplex[nlem]();
    gls[gi] = new dcomplex[nlem]();
  }
  sam = new dcomplex*[ndit];
  for (int si = 0; si < ndit; si++) sam[si] = new dcomplex[nlemt]();
  gis_size_0 = ndi;
  sam_size_0 = ndit;
}

C9::~C9() {
  for (int gi = gis_size_0 - 1; gi > -1; gi--) {
    delete[] gis[gi];
    delete[] gls[gi];
  }
  delete[] gis;
  delete[] gls;
  for (int si = sam_size_0 - 1; si > -1; si--) delete[] sam[si];
  delete[] sam;
}
