/* Distributed under the terms of GPLv3 or later. See COPYING for details. */

/*! \file algebraic.cpp
 *
 * \brief Implementation of algebraic functions with different call-backs.
 */
#ifndef INCLUDE_TYPES_H_
#include "../include/types.h"
#endif

#ifdef USE_LAPACK
#ifndef INCLUDE_LAPACK_CALLS_H_
#include "../include/lapack_calls.h"
#endif
#endif

#ifndef INCLUDE_ALGEBRAIC_H_
#include "../include/algebraic.h"
#endif

// >>> FALL-BACK FUNCTIONS DECLARATION <<< //
extern void lucin(dcomplex **mat, np_int max_size, np_int size, int &ier);
// >>>   END OF FALL-BACK FUNCTIONS    <<< //

using namespace std;

void invert_matrix(dcomplex **mat, np_int size, int &ier, np_int max_size) {
  ier = 0;
#ifdef USE_LAPACK
  zinvert(mat, size, ier);
#else
  lucin(mat, max_size, size, ier);
#endif
}
