/* Copyright (C) 2024   INAF - Osservatorio Astronomico di Cagliari

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   A copy of the GNU General Public License is distributed along with
   this program in the COPYING file. If not, see: <https://www.gnu.org/licenses/>.
 */

/*! \file utils.h
 *
 * \brief Definition of auxiliary code utilities.
 */

#ifndef INCLUDE_UTILS_H_
#define INCLUDE_UTILS_H_

/*! \brief Write a double complex matrix to a text file.
 *
 * \param file_name: `const string&` Name of the file to be written.
 * \param mat: `dcomplex **` Pointer to the matrix.
 * \param rows: `np_int` Number of rows in the matrix.
 * \param columns: `np_int` Number of columns in the matrix.
 */
int write_dcomplex_matrix(const std::string& file_name, dcomplex **mat, np_int rows, np_int columns);

#endif
