/* Copyright (C) 2024   INAF - Osservatorio Astronomico di Cagliari

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   A copy of the GNU General Public License is distributed along with
   this program in the COPYING file. If not, see: <https://www.gnu.org/licenses/>.
 */

/*! \file utils.cpp
 *
 * \brief Implementation of auxiliary code utilities.
 */

/* Copyright (C) 2024   INAF - Osservatorio Astronomico di Cagliari

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   A copy of the GNU General Public License is distributed along with
   this program in the COPYING file. If not, see: <https://www.gnu.org/licenses/>.
 */

/*! \file utils.h
 *
 * \brief Definition of auxiliary code utilities.
 */

#include <cstdio>
#ifndef INCLUDE_TYPES_H_
#include "../include/types.h"
#endif
#ifndef INCLUDE_UTILS_H_
#include "../include/utils.h"
#endif

using namespace std;

int write_dcomplex_matrix(const std::string& file_name, dcomplex **mat, np_int rows, np_int columns) {
  int result = 0;
  FILE* output = fopen(file_name.c_str(), "w");
  if (output) {
    string str_format = "%5d%5d (%13.5lE,%13.5lE)\n";
    if (sizeof(np_int) > sizeof(int)) {
      str_format = "%5ld%5ld (%13.5lE,%13.5lE)\n";
    }
    for (np_int i = 0; i < rows; i++) {
      for (np_int j = 0; j < columns; j++) {
	fprintf(output, str_format.c_str(), i, j, real(mat[i][j]), imag(mat[i][j]));
      }
    }
    fclose(output);
  } else {
    // Could not open the output file.
    result = 1;
  }
  return result;
}
