# NP_TMcode project

This project is the T-matrix based suite of codes by the Messina group (Borghese, Denti, Saija, Iatì) to compute scattering and extinction properties of realistic particles that can be represented as an arbitrary assembly of individually spherically symmetric subparticles, whose classical optical constants are known. Using an arbitrarily large set of arbitrarily small spherically symmetric subparticles one can obviously approximate any real particle, very much as small enough pixels can approximate an image.

The aim of the project, funded by PNRR-CNS, is to refactor the original, very old legacy Fortran codes, casting them in a modern language that allows them to be parallelised and run efficiently on current and forthcoming HPC architectures.

The current implementation offers a set of elementary tests to check that the original FORTRAN code can be compiled and executed on a limited set of pre-defined input data. The functionality of this initial stage can be verified by cloning the gitLab repository on a local machine and building the binaries from the `src` folder.

*NOTE:* The building process requires a working installation of the GNU Compiler Collection (`gcc`), of the GNU FORTRAN compiler (`gfortran`) and of the GNU `make` builder.

# License

   Copyright 2004 INAF - Osservatorio Astronomico di Cagliari

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   