# Folder instructions

This directory collects the source code of the original programs and the development folders.

## Instructions

The original code is contained in the folders named `cluster`, `sphere` and `trapping`. The `testing` folder contains additional programs that are used to perform consistency tests during the development state. Each folder contains a `Makefile` to compile either the whole program set or the single programs. A global `Makefile`, which contains instructions to build all the original source code, is available directly in the `src` folder.

In all cases, build commands executed through `make` will output the object files and the linked binaries in the proper folders under the build directory.

## *FORTRAN* code setup and execution (requires `gfortran` and GNU `make`)

1. cd to the `src` folder.
2. Run `make` as:

   > make

3. cd to the `build/sphere` folder.
4. Run `sph` following the instructions given in `build/README.md`
5. cd to the `build/cluster` folder.
6. Run `clu` following the instructions given in `build/README.md`

## *C++* code setup and execution (requires `g++` and GNU `make`)

1. Follow the *FORTRAN* code setup steps (these build the *C++* version too).
2. cd to the `build/sphere` folder.
3. Run `np_sphere`:

   > ./np_sphere

4. Check the consistency between the text files named `OSPH` and `c_OSPH`
5. cd to the `build/cluster` folder.
6. Run `np_cluster`:

   > ./np_cluster

7. Check the consistency between the text files named `OCLU` and `c_OCLU`

# License

   Copyright 2004 INAF - Osservatorio Astronomico di Cagliari

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
