/* Copyright 2024 INAF - Osservatorio Astronomico di Cagliari

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

/*! \file algebraic.h
 *
 * \brief Declaration of algebraic functions with different call-backs.
 *
 * In principle, the system that runs NP_TMcode may offer various types of
 * optimized features, such as multi-core or multi-node scaling, GPU offload,
 * or external libraries. This header collects a set of functions that can
 * perform standard algebraic operations choosing the most optimized available
 * system as a call-back. If no optimization is detected, eventually the 
 * legacy serial function implementation is used as a fall-back.
 */

#ifndef INCLUDE_ALGEBRAIC_H_
#define INCLUDE_ALGEBRAIC_H_

/*! \brief Perform in-place matrix inversion.
 *
 * \param mat: `complex double **` The matrix to be inverted (must be a square matrix).
 * \param size: `np_int` The size of the matrix (i.e. the number of its rows or columns).
 * \param ier: `int &` Reference to an integer variable for returning a result flag.
 * \param max_size: `np_int` The maximum expected size (required by some call-backs,
 * optional, defaults to 0).
 */
void invert_matrix(dcomplex **mat, np_int size, int &ier, np_int max_size=0);

#endif
