/* Copyright 2024 INAF - Osservatorio Astronomico di Cagliari

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

/*! \file algebraic.cpp
 *
 * \brief Implementation of algebraic functions with different call-backs.
 */
#ifndef INCLUDE_TYPES_H_
#include "../include/types.h"
#endif

#ifdef USE_LAPACK
#ifndef INCLUDE_LAPACK_CALLS_H_
#include "../include/lapack_calls.h"
#endif
#endif

#ifdef USE_MAGMA
#ifndef INCLUDE_MAGMA_CALLS_H_
#include "../include/magma_calls.h"
#endif
#endif

#ifndef INCLUDE_ALGEBRAIC_H_
#include "../include/algebraic.h"
#endif

// >>> FALL-BACK FUNCTIONS DECLARATION <<< //
extern void lucin(dcomplex **mat, np_int max_size, np_int size, int &ier);
// >>>   END OF FALL-BACK FUNCTIONS    <<< //

using namespace std;

void invert_matrix(dcomplex **mat, np_int size, int &ier, np_int max_size) {
  ier = 0;
#ifdef USE_MAGMA
  magma_zinvert(mat, size, ier);
#elif defined USE_LAPACK
  zinvert(mat, size, ier);
#else
  lucin(mat, max_size, size, ier);
#endif
}
