# FC defines the fortran compiler to use. If undefined, GNU Make tries to use `f77`
ifndef FC
override FC=gfortran
endif

# FCFLAGS defines the compilation options for the fortran compiler
ifndef FCFLAGS
override FCFLAGS=-std=legacy -O3
endif

# LDFLAGS defines the default linker flags
ifndef LDFLAGS
override LDFLAGS=
endif

# CXX defines the default C++ compiler to use. If undefined, GNU Make tries to use g++
ifndef CXX
override CXX=g++
endif

# HDF5_INCLUDE defines the default path to the HDF5 include files to use
ifndef HDF5_INCLUDE
override HDF5_INCLUDE=/usr/include/hdf5/serial
endif

# CXXFLAGS defines the default compilation options for the C++ compiler
ifndef CXXFLAGS
#override CXXFLAGS=-O3 -ggdb -pg -coverage -I$(HDF5_INCLUDE)
override CXXFLAGS=-O3 -I$(HDF5_INCLUDE)
endif

# HDF5_LIB defines the default path to the HDF5 libraries to use
# CXXLDFLAGS defines the default linker flags to use for C++ codes
ifndef CXXLDFLAGS
ifndef HDF5_LIB
override HDF5_LIB=/usr/lib/x86_64-linux-gnu/hdf5/serial
endif
override CXXLDFLAGS=-L/usr/lib64 -L$(HDF5_LIB) -lhdf5 $(LDFLAGS)
#else
#override CXXLDFLAGS=-L/usr/lib64 -L$(HDF5_LIB) -lhdf5 $(CXXLDFLAGS)
endif

%.o : %.f
	$(FC) $(FCFLAGS) -c -o $@ $<

%.o : %.cpp
	$(CXX) $(CXXFLAGS) -c -o $@ $<

$(OBJDIR)/%.o : %.f
	$(FC) $(FCFLAGS) -c -o $@ $<

$(OBJDIR)/%.o : %.cpp
	$(CXX) $(CXXFLAGS) -c -o $@ $<

$(OBJDIR)/%.o : ../libnptm/%.cpp
	$(CXX) $(CXXFLAGS) -c -o $@ $<
