# Folder instructions

This directory contains scripts and tools to evaluate the code functionality.

## Instructions

The code migration stage can be considered successfully fulfilled with the solution of the single sphere and of the cluster of spheres cases in *C++*. To test the reliability of the code, the *C++* version needs to produce consistent output with respect to the original *FORTRAN* code. Since the output files are generally too large for manual inspection and they can be affected by different approximations or numeric noise, a series of scripts designed to compare the two versions and to pin-point possible differences is provided in this folder. The scripts are written in *python*, therefore they need an available *python* environment to work.

## Comparing the results of *FORTRAN* and *C++* codes

1. Follow the instructions to build and run the *FORTRAN* and *C++* versions of the code.
2. Run the `pycompare.py` script providing the following minimal arguments:

   > $PATH_TO_SCRIPT/pycompare.py --ffile=FORTRAN_OUTPUT --cfile=C++_OUTPUT

(The above assumes that `PATH_TO_SCRIPT` is a variable that expands to the path were the script is located). The required output files are called by default `OSPH` and `OCLU` by *FORTRAN* and `c_OSPH` and `c_OCLU` by *C++*, depending on whether the sphere or the cluster case was executed. 

3. Check the output of the script to verify that it detects 0 errors and finishes in a `SUCCESS` state.
4. In case of necessity, add the `--html` argument to produce an *HTML* log showing the possible differences and a classification of their severity.
5. Issuing:

   > $PATH_TO_SCRIPT/pycompare.py --help

or just:

   > $PATH_TO_SCRIPT/pycompare.py

will print a help screen, giving a brief explanation of all the possible options.